<?php

namespace IRI\Bundle\WikiTagBundle\Entity;

use Doctrine\ORM\EntityRepository;
use IRI\Bundle\WikiTagBundle\Utils\WikiTagUtils;
use IRI\Bundle\WikiTagBundle\Entity\Tag;

/**
 * TagRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class TagRepository extends EntityRepository
{
    public function getTagCloud($max_tags)
    {
        $qb = $this->getEntityManager()->createQueryBuilder();
        $qb->select('t.id', 't.label', 'COUNT( dt.id ) AS nb_docs');
        $qb->from('WikiTagBundle:Tag','t');
        $qb->leftJoin('t.documents', 'dt', 'WITH', 't = dt.tag');
        $qb->addGroupBy('t.id');
        $qb->addOrderBy('nb_docs','DESC');
        $qb->setMaxResults($max_tags);
        
        $query = $qb->getQuery();
        return $query->getResult();
    }
    
    public function getCompletion($seed)
    {
        $qb = $this->getEntityManager()->createQueryBuilder();
        $qb->select('t.label');
        $qb->from('WikiTagBundle:Tag','t');
        $qb->where($qb->expr()->orx(
            $qb->expr()->like('t.label',$qb->expr()->literal("%".addcslashes(mysql_real_escape_string($seed),"%_"))),
            $qb->expr()->like('t.label',$qb->expr()->literal("% ".addcslashes(mysql_real_escape_string($seed),"%_")."%"))
        ));
        
        $query = $qb->getQuery();
        
        return $query->getResult();
        
    }
    
    /**
    * Get or create tag. Returns an array(tag:WikiTagTag, revision_id=int, created:Boolean)
    * @param $tag_label
    * @param $doctrine
    * @return multitype:boolean Ambigous <NULL, \IRI\Bundle\WikiTagBundle\Entity\Tag> Ambigous <NULL, unknown, mixed, string> (array(\IRI\Bundle\WikiTagBundle\Model\TagInterface, revision_id=int, created:Boolean))
    */
    public function getOrCreateTag($tag_label)
    {
        $tag_label_normalized = WikiTagUtils::normalizeTag($tag_label);
        // We get the wikipedia references for the tag_label
        // We get or create the tag object
        $tags = $this->findBy(array('normalizedLabel' => $tag_label_normalized));
        $tag = null;
        foreach ($tags as $t) {
            if($tag==null || $t->getUrlStatus()!=Tag::$TAG_URL_STATUS_DICT['null_result']) {
                $tag = $t;
                if($t->getUrlStatus()!=Tag::$TAG_URL_STATUS_DICT['null_result']) {
                    break;
                }
            }
        }
        $wp_request_done = false;
        if($tag==null) {
            $tag = new Tag();
            $tag->setLabel($tag_label_normalized);
            $tag->setOriginalLabel($tag_label);
            $tag->setNormalizedLabel($tag_label_normalized);
            $created = true;
        }
        else {
            $created = false;
            $match_exists = false;
            // Even if a tag with the normalised label exists, IF this tag is not wikipedia semantised,
            // we search if a wikipedia semantised version exists in the base
            foreach ($tags as $t) {
                if($t->getUrlStatus()==Tag::$TAG_URL_STATUS_DICT['match']) {
                    $tag = $t;
                    $match_exists = true;
                    break;
                }
            }
            if($match_exists==false) {
                try {
                    $wp_response = WikiTagUtils::getWikipediaInfo($tag_label_normalized);
                }
                catch (\Exception $e){
                    throw new \Exception($e->getMessage());
                }
                $status = $wp_response['status'];
                if($status==Tag::$TAG_URL_STATUS_DICT['match']) {
                    $tag = new Tag();
                    $tag->setLabel($tag_label_normalized);
                    $tag->setOriginalLabel($tag_label);
                    $tag->setNormalizedLabel($tag_label_normalized);
                    $created = true;
                    $wp_request_done = true;
                }
            }
        }
    
        // We request Wikipedia if the tag is created
        if($created==true) {
            
            if($wp_request_done==false) {
                try {
                    $wp_response = WikiTagUtils::getWikipediaInfo($tag_label_normalized);
                }
                catch (\Exception $e){
                    throw new \Exception($e->getMessage());
                }
            }
            
            $tag->setWikipediaInfo($wp_response);
    
            // Save datas.
            $em = $this->getEntityManager();
            $em->persist($tag);
            $em->flush();
                
            $wikipedia_revision_id = $wp_response['revision_id'];
    
        }
        else if($tag!=null && $tag->getWikipediaPageId()!=null) {
            try {
                $wp_response = WikiTagUtils::getWikipediaInfo(null, $tag->getWikipediaPageId());
            }
            catch (\Exception $e){
                throw new \Exception($e->getMessage());
            }
            $wikipedia_revision_id = $wp_response['revision_id'];
        }
        else {
            $wikipedia_revision_id = null;
        }
    
        return array($tag, $wikipedia_revision_id, $created);//, $wpReponse);
    }
    
    
}