<?php

namespace IRI\Bundle\WikiTagBundle\Entity;

use Doctrine\ORM\EntityRepository;

/**
 * DocumentTagRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class DocumentTagRepository extends EntityRepository
{
    /**
    *  Find ordered tags by document id
    */
    public function findOrderedTagsForDoc($doc_id)
    {
        return $this->getEntityManager()
        ->createQuery("SELECT doctag FROM WikiTagBundle:DocumentTag doctag WHERE doctag.document=:doc_id ORDER BY doctag.tagOrder ASC")
        ->setParameter("doc_id", $doc_id)
        ->getResult();
    }
    
    /**
     *  Gets the max order of all tags for one document
     */
    public function getMaxOrder($doc_id)
    {
        return $this->getEntityManager()
        ->createQuery("SELECT MAX(doctag.tagOrder) FROM WikiTagBundle:DocumentTag doctag  WHERE doctag.document= :doc_id")
        ->setParameter("doc_id", $doc_id)
        ->getResult();
    }
    
}