<?php

namespace IRI\Bundle\WikiTagBundle\Entity;

use Doctrine\ORM\EntityRepository;

/**
 * TagRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class TagRepository extends EntityRepository
{
    public function getTagCloud($max_tags)
    {
        $qb = $this->getEntityManager()->createQueryBuilder();
        $qb->select('t.id', 't.label', 'COUNT( dt.id ) AS nb_docs');
        $qb->from('WikiTagBundle:Tag','t');
        $qb->leftJoin('t.documents', 'dt', 'WITH', 't = dt.tag');
        $qb->addGroupBy('t.id');
        $qb->addOrderBy('nb_docs','DESC');
        $qb->setMaxResults($max_tags);
        
        $query = $qb->getQuery();
        return $query->getResult();
    }
    
    public function getCompletion($seed)
    {
        $qb = $this->getEntityManager()->createQueryBuilder();
        $qb->select('t.label');
        $qb->from('WikiTagBundle:Tag','t');
        $qb->where($qb->expr()->orx(
            $qb->expr()->like('t.label',$qb->expr()->literal("%".addcslashes(mysql_real_escape_string($seed),"%_"))),
            $qb->expr()->like('t.label',$qb->expr()->literal("% ".addcslashes(mysql_real_escape_string($seed),"%_")."%"))
        ));
        
        $query = $qb->getQuery();
        
        return $query->getResult();
        
    }
}