<?php
/*
 * This file is part of the WikiTagBundle package.
 *
 * (c) IRI <http://www.iri.centrepompidou.fr/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace IRI\Bundle\WikiTagBundle\Search;
 
use Symfony\Component\DependencyInjection\ContainerAware;
use Symfony\Component\DependencyInjection\ContainerInterface;

class Search extends ContainerAware
{
    /**
     * Get the container associated with this service.
     * @return ContainerInterface
     */
    public function getContainer()
    {
        return $this->container;
    }
    
    /**
     * Public constructor with container as parameter for contruct injection.
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        $this->setContainer($container);
    }
    
    private $doctrine;
    
    public function getDoctrine()
    {
        if(is_null($this->doctrine))
        {
            $this->doctrine = $this->getContainer()->get('doctrine');
        }
        return $this->doctrine;
    }
    
    /**
     * Service to reorder the tags using their notes in the index search
     * @param IRI\Bundle\WikiTagBundle\Model\DocumentInterface $document
     */
    public function reorderTagsForDocument($document)
    {
        $doctrine = $this->getContainer()->get('doctrine');
        $res = $doctrine->getRepository('WikiTagBundle:Document');
        $tags_score = array();
        foreach($document->getTags() as $tag)
        {
            $label = $tag->getTag()->getLabel();
            
            //
            $fields = $this->getContainer()->getParameter("wiki_tag.fields");
            
            $fieldquery = array();
            foreach ($fields as $fieldname => $fielddef) {
                $columns = "$fieldname";
                $value = $label;
                if(isset($fielddef['weight']))
                {
                    $weight = $fielddef['weight'];
                }
                else
                {
                    $weight = 1.0;
                }
                $fieldquery[] = array("columns"=>$columns, "value"=>$value, "weight"=>$weight);
            }
            
            $score_res = $res->search($fieldquery, array("id"=>$document->getId()));
            
            if(count($score_res)>0)
            {
                $score = floatval($score_res[0]['score']);
            }
            else
            {
                $score = 0.0;
            }
            $tags_score[] = array($score,$tag);
        }
        // sort tags based on score
        $i=1;
        usort($tags_score, function($a, $b) {
            return $a[0]<$b[0]?1:-1;
        });

        foreach($tags_score as $item)
        {
            $tag = $item[1];
            $tag->setTagOrder($i++);
            $tag->setIndexNote($item[0]);
            $doctrine->getEntityManager()->persist($tag);
        }
        
    }
    
    public function getTagCloud($max_tags)
    {
        $qb = $this->getDoctrine()->getEntityManager()->createQueryBuilder();
        $qb->select('t', 'COUNT( dt.id ) AS nb_docs');
        $qb->from('WikiTagBundle:Tag','t');
        $qb->leftJoin('t.documents', 'dt', 'WITH', 't = dt.tag');
        $qb->addGroupBy('t.id');
        $qb->addOrderBy('nb_docs','DESC');
        
    }
    
        
}