<?php

namespace IRI\Bundle\WikiTagBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/extension.html#cookbook-bundles-extension-config-class}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritDoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('wiki_tag');
        
        $rootNode
            ->children()
                ->scalarNode('route_for_documents_by_tag')->defaultNull()->end()
                ->scalarNode('document_class')->isRequired()->end()
                ->scalarNode('document_id_column')->defaultValue('id')->end()
            ->end()
            ->fixXmlConfig('field')
            ->children()
                ->arrayNode('fields')
                    ->treatNullLike(array())
                    ->useAttributeAsKey('name')
                    ->prototype('array')
                        ->performNoDeepMerging()
                        ->children()
                            ->scalarNode('type')->defaultValue('text')->end()
                            ->scalarNode('length')
                                ->beforeNormalization()
                                    ->ifString()
                                    ->then(function($v) { return intval($v); })
                                ->end()
                            ->end()
                            ->scalarNode('weight')->defaultValue(1.0)
                                ->beforeNormalization()
                                    ->ifString()
                                    ->then(function($v) { return floatval($v); })
                                ->end()
                            ->end()
                            ->scalarNode('accessor')->end()
                        ->end()
                    ->end()
                ->end()
            ->end();
        
        return $treeBuilder;
    }
}
