<?php
/*
 * This file is part of the WikiTagBundle package.
 *
 * (c) IRI <http://www.iri.centrepompidou.fr/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace IRI\Bundle\WikiTagBundle\Tests\Services;

require_once(__DIR__ . "/../../../../../../../app/AppKernel.php");

class SearchServiceTest extends \PHPUnit_Framework_TestCase
{

    protected $_container;
    
    public function __construct()
    {
        $kernel = new \AppKernel("test", true);
        $kernel->boot();
        $this->_container = $kernel->getContainer();
        parent::__construct();
    }
    
    protected function get($service)
    {
        return $this->_container->get($service);
    }
    
    
    public function testTagCloud()
    {
        
        $search_service = $this->get("wiki_tag.search");
        
        $result = $search_service->getTagCloud(30);
        
        $this->assertNotNull($result, "tag cloud should not be null");
        $this->assertLessThanOrEqual(30, count($result));
    }

    
    public function testCompletion()
    {
    
        $search_service = $this->get("wiki_tag.search");
    
        $result = $search_service->completion("tag");
    
        $this->assertNotNull($result, "tag cloud should not be null");
        $this->assertEquals(4, count($result));
    }
    
    
}

