<?php
/*
 * This file is part of the WikiTagBundle package.
 *
 * (c) IRI <http://www.iri.centrepompidou.fr/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace IRI\Bundle\WikiTagBundle\Command;

use Doctrine\ORM\Query;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class SyncDocumentsCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        parent::configure();
        
        $this
            ->setName('wikitag:sync-doc')
            ->setDescription('Synchronize and index document class')
            ->addOption('clear', 'c', InputOption::VALUE_NONE, "clear all docs");
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $class = $this->getContainer()->getParameter('wiki_tag.document_class');
        $clear = $input->getOption('clear');
     
        
        $doctrine = $this->getContainer()->get('doctrine');
        
        $docrep = $doctrine->getRepository('WikiTagBundle:Document');
        $rep = $doctrine->getRepository($class);
        
        if(is_null($rep)) {
            //TODO : translate
            $output->writeln("$class does not have a repository : exiting.");
            return ;
        }
        
        //TODO : check class to implement DocumentInterface
        //TODO : write progress
        $doclist = $rep->findAll();
        foreach ($doclist as $doc) {
            $docrep->writeDocument($doc, $this->getContainer()->getParameter('wiki_tag.document_id_column'), $this->getContainer()->getParameter('wiki_tag.fields'));
        }
        $doctrine->getEntityManager()->flush();
        
        if($clear) {
            
            $req = $doctrine->getEntityManager()->createQuery("DELETE WikiTagBundle:Document wtdoc WHERE wtdoc.externalId NOT IN (SELECT doc FROM $class doc)");
            $req->getResult();
            $doctrine->getEntityManager()->flush();
        }

        $output->writeln(strval(count($doclist)) ." documents imported.");
    }
}