﻿// -*- coding: utf-8 -*-
function wikitag_init_tags_events()
{
    // Tag simple operations : activate/unactivate wp link, reset wp info, remove wp link, remove tag from list
    $(".wikitag_reset_wp_info").click(function(e){
        if(confirm("Confirmez-vous le rétablissement du label original de ce tag ?")){
            wikitag_update_tag(this);
        }
    });
    $(".wikitag_remove_wp_link").click(function(e){
        if(confirm("Confirmez-vous le suppression du lien Wikipédia pour le tag \"" + $(this).attr('alt') + "\" ?")){
            wikitag_update_tag(this);
        }
    });
    $(".wikitag_remove_tag_from_list").click(function(){
        if(confirm("Confirmez-vous la suppression du tag \"" + $(this).attr('alt') + "\" de la liste courante ?")){
            wikitag_update_tag(this);
        }
    });
    
    // Wikipedia search management (autocompletion and save changes)
    $.editable.addInputType('autocomplete', {
    	element : $.editable.types.text.element,
    	plugin : function(settings, original) {
    		$('input', this).autocomplete(settings.autocomplete);
    	}
    });
    $(".wikipediatag").editable(modify_tag_url, { 
    	indicator : "<img src='"+static_url+"images/indicator.gif'>",
    	type      : "autocomplete",
    	tooltip   : "Cliquer pour éditer...",
    	onblur    : "submit",
    	submitdata: {
            csrfmiddlewaretoken:global_csrf_token, 
            wikitag_document_id:$('#wikitag_document_id').val(),
            num_page:$('#num_page').val(),
            nb_by_page:$('#nb_by_page').val(),
            sort:$('#sort').val(),
            searched:$('#searched_str').val()
        },
    	callback  : function(value, settings) {
            $('#wikitag_table_container').html(value);
            wikitag_init_tags_events();
    	},
		onerror: function(settings, original, jqXHR) {
			resp = $.parseJSON(jqXHR.responseText);
			alert(resp.message);
			original.reset();
		},
    	autocomplete : {
			source: function( request, response ) {
				$.ajax({
					url: "http://fr.wikipedia.org/w/api.php",
					dataType: "jsonp",
					data: {
						action: "opensearch",
						limit: "20",
						namespace: "0",
						format: "json",
						search: request.term
					},
					success: function( data ) {
						response( $.map( data[1], function( item ) {
							return {
								label: item,
								value: item
							}
						}));
					}
				});
			},
			minLength: 2,
			open: function() {
				$( this ).removeClass( "ui-corner-all" ).addClass( "ui-corner-top" );
			},
			close: function() {
				$( this ).removeClass( "ui-corner-top" ).addClass( "ui-corner-all" );
			}
    	}
    });
    
    // Update alias management
    $(".wikitag_alias").editable(update_tag_alias_url, {
    	indicator : "<img src='"+static_url+"images/indicator.gif'>",
    	type      : "text",
    	placeholder:"",
    	tooltip   : "Cliquer pour éditer...",
    	onblur    : "submit",
    	submitdata: {
            csrfmiddlewaretoken:global_csrf_token, 
            wikitag_document_id:$('#wikitag_document_id').val(),
            num_page:$('#num_page').val(),
            nb_by_page:$('#nb_by_page').val(),
            sort:$('#sort').val(),
            searched:$('#searched_str').val()
        },
    	callback  : function(value, settings) {
            $('#wikitag_table_container').html(value);
            wikitag_init_tags_events();
    	}
    });
    
    // Tag categories management
    $(".wikitag_category").editable(update_tag_category_url, {
    	indicator : "<img src='"+static_url+"/images/indicator.gif'>",
    	type      : "select",
        data      : categories_list,
    	placeholder:"",
    	tooltip   : "Cliquer pour éditer...",
    	onblur    : "submit",
    	submitdata: {
            csrfmiddlewaretoken:global_csrf_token,
            wikitag_document_id:$('#wikitag_document_id').val(),
            num_page:$('#num_page').val(),
            nb_by_page:$('#nb_by_page').val(),
            sort:$('#sort').val(),
            searched:$('#searched_str').val()
        },
    	callback  : function(value, settings) {
            $('#wikitag_table_container').html(value);
            wikitag_init_tags_events();
    	}
    });
    
    // Tag table drag and drop
    $("#wikitag_table").tableDnD({
        onDragClass: "wikitag_dragged_row",
        onDrop: function(table, row){
            old_order = row.id;
            $($(row).children()[1]).html("<img src='"+static_url+"/images/indicator.gif'/>");
            rows = table.tBodies[0].rows;
            nb_rows = rows.length;
            for(var i=1; i<nb_rows; i++){
                if(rows[i].id==old_order){
                    new_order = i; // No need to +1 because rows[0] are headers
                    $.ajax({
                        url: tag_up_down_url,
                        type: 'POST',
                        data: {csrfmiddlewaretoken:global_csrf_token, 
                               wikitag_document_id:$('#wikitag_document_id').val(),
                               new_order:new_order,
                               old_order:old_order
                               },
                        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
                        //dataType: 'json',
                        success: function(msg, textStatus, XMLHttpRequest) {
                            $('#wikitag_table_container').html(msg);
                            wikitag_init_tags_events();
                        }
                    });
                }
            }
        },
        dragHandle: "wikitag_updown_td"
    });
}

function wikitag_init_datasheet_events()
{
    var select_done = false;
    // Wikipedia search management (new tag)
    $("#wikitag_wp_search").autocomplete({
        source: function( request, response ) {
            $.ajax({
                url: "http://fr.wikipedia.org/w/api.php",
                dataType: "jsonp",
                data: {
                    action: "opensearch",
                    limit: "20",
                    namespace: "0",
                    format: "json",
                    search: request.term
                },
                success: function( data ) {
                    response( $.map( data[1], function( item ) {
                        return {
                            label: item,
                            value: item
                        }
                    }));
                }
            });
        },
        select: function(event, ui) { 
            // Since the event still did not update wp_search's val, we force it.
            $("#wikitag_wp_search").val(ui.item.label);
            select_done = true;
            $("#wikitag_ok_search").click();
        },
        minLength: 2,
        open: function() {
            $( this ).removeClass( "ui-corner-all" ).addClass( "ui-corner-top" );
        },
        close: function() {
            $( this ).removeClass( "ui-corner-top" ).addClass( "ui-corner-all" );
        }
    });
    $('#wikitag_wp_search').keyup(function(e){
        if((e.keyCode==13) && ($("#wikitag_wp_search").val()!="") && (select_done==false)){
            add_tag($("#wikitag_wp_search").val());
        }
        select_done = false;
    });
    $("#wikitag_ok_search").click(function(){
        if($("#wikitag_wp_search").val()!=""){
            add_tag($("#wikitag_wp_search").val());
        }
    });
    $("#wikitag_tags_sort").click(function(e){
    	 e.preventDefault();
    	if(confirm("Confirmez-vous le tri des tags ?")) {
    		reorder_tags();
    	}
    });
    /*
    // Validate sheet management : the radiobutton name has is "'gr_validated' + datasheet.hda_id"
    $("#validated").click(function(e){
        e.preventDefault();
        // We count the number of tags. It has to be between 5 and 25
        var nb_tags = $('#tag_table tr').length - 1;
        if(nb_tags<5 || nb_tags>25){
            alert("Cette fiche n'est pas validable : elle doit contenir entre 5 et 25 tags.");
        }
        else{
            if(confirm("Confirmez-vous la validation de cette fiche ? Elle contient " + nb_tags + " tags.")){
                window.location = validate_datasheet_url + "/" + $('#wikitag_document_id').val() + "/true";
            }
        }
    });
    $("#not_validated").click(function(e){
        e.preventDefault();
        if(confirm("Confirmez-vous l'invalidation de cette fiche ?")){
            window.location = validate_datasheet_url + "/" + $('#wikitag_document_id').val() + "/false";
        }
    });
    */
}

function wikitag_update_tag(btn)
{
    new_checked = false;
    if ($(btn).is(".wikitag_remove_tag_from_list")) {
        var url = remove_tag_from_list_url;
        var id_tag = $(btn).attr('id');
    }
    else if ($(btn).is(".wikitag_reset_wp_info")) {
        var url = reset_wp_info_url;
        var id_tag = $(btn).html();
        $(btn).html("<img src='"+static_url+"/images/indicator.gif'>");
    }
    else if ($(btn).is(".wikitag_remove_wp_link")) {
        var url = remove_wp_link_url;
        var id_tag = $(btn).attr('id');
    }
    
    // 2 cases : 
    // - ordered tag for one datasheet : $('#wikitag_document_id') is not null
    // - all tags list : $('#wikitag_document_id') is null and $('#num_page') and $('#nb_by_page') are not null
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token, 
               wikitag_document_id:$('#wikitag_document_id').val(),
               num_page:$('#num_page').val(),
               nb_by_page:$('#nb_by_page').val(),
               sort:$('#sort').val(),
               searched:$('#searched_str').val(),
               tag_id:id_tag,
               activated:new_checked
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            $('#wikitag_table_container').html(msg);
            wikitag_init_tags_events();
        },
		error: function(jqXHR, textStatus, errorThrown) {
			resp = $.parseJSON(jqXHR.responseText);
			alert(resp.message);
			$(btn).html(id_tag);
		}
    });
}

function wikitag_up_down(arrow)
{
    if ($(arrow).is(".up")) {
        mv = "u";
    } else {
        mv = "d";
    }
    var url = tag_up_down_url;
    var id_tag = $(arrow).attr('id');
    // This indicates the position (from 0) of the tag in the list. NB : it is different from the TagSheet.order in the database.
    var pos_tag = $(arrow).attr('pos');
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token, 
               wikitag_document_id:$('#wikitag_document_id').val(),
               tag_id:id_tag,
               move:mv,
               tag_pos:pos_tag
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            $('#wikitag_table_container').html(msg);
            wikitag_init_tags_events();
        }
    });
}

function add_tag(tag_label)
{
    $("#wikitag_ok_search").html("<img src='"+static_url+"/images/indicator.gif'>");
    var url = add_tag_url;
    $.ajax({
        url: url,
        type: 'POST',
        data: {csrfmiddlewaretoken:global_csrf_token,
               wikitag_document_id:$('#wikitag_document_id').val(),
               value:tag_label
               },
        // bug with jquery >= 1.5, "json" adds a callback so we don't specify dataType
        //dataType: 'json',
        success: function(msg, textStatus, XMLHttpRequest) {
            $('#wikitag_table_container').html(msg);
            wikitag_init_tags_events();
            // And scroll to the bottom
            $("html").animate({ scrollTop: $(document).height() }, 500);
        },
        error: function(jqXHR, textStatus, errorThrown) {
			resp = $.parseJSON(jqXHR.responseText);
			alert(resp.message);
        },
        complete: function(){
            // We empty the input and hide the ok button
            $("#wikitag_wp_search").val("");
            $("#wikitag_ok_search").html("<b>OK</b>");
        }
    });
}

function reorder_tags() {
	$('#wikitag_tags_sort').attr("disabled", "disabled");
	var tag_sort_old_src = $("#wikitag_tags_sort").attr("src");
	$("#wikitag_tags_sort").attr("src",static_url+"images/indicator.gif");
	$.ajax({
		url: reorder_tag_datasheet_url,
		type: 'POST',
		data: {
			csrfmiddlewaretoken:global_csrf_token,
            wikitag_document_id:$('#wikitag_document_id').val()
		},
        success: function(msg, textStatus, XMLHttpRequest) {
            $('#wikittag_table_container').html(msg);
            wikitag_init_tags_events();
            // And scroll to the bottom
            $("html").animate({ scrollTop: $(document).height() }, 500);
        },
        complete: function(){
        	$("#wikitag_tags_sort").attr("src",tag_sort_old_src);
        	$('#wikitag_tags_sort').removeAttr("disabled");
        }
	});
}

