<?php

namespace IRI\Bundle\WikiTagBundle\Entity;

use Doctrine\ORM\EntityRepository;
use IRI\Bundle\WikiTagBundle\Model\DocumentInterface;

/**
 * DocumentRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class DocumentRepository extends EntityRepository
{
    function findOneByExternalId($external_id)
    {
        return $this->findOneBy(array("externalId" => strval($external_id)));
    }
    
    function writeDocument(DocumentInterface $document)
    {
        # get document from id
        $baseDocument = $this->findOneByExternalId($document->getId());
    
        if(is_null($baseDocument))
        {
            $baseDocument = new Document();
            $baseDocument->setExternalId(strval($document->getId()));
        }
        $baseDocument->setDescription($document->getDescription());
        $baseDocument->setTitle($document->getTitle());
        
        $this->getEntityManager()->persist($baseDocument);
        $this->getEntityManager()->flush();
        return $baseDocument;
    
    }
    
    function removeDocument(DocumentInterface $document)
    {
        $baseDocument = $this->findOneByExternalId($document->getId());
        if(!is_null($baseDocument))
        {
            $this->getEntityManager()->remove($baseDocument);
        }
    }
    
}