<?php

namespace IRI\Bundle\WikiTagBundle\Entity;

use Doctrine\ORM\EntityRepository;
use IRI\Bundle\WikiTagBundle\Model\DocumentInterface;

/**
 * DocumentRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class DocumentRepository extends EntityRepository
{
    
    function writeDocument(DocumentInterface $document)
    {
        # get document from id
        $baseDocument = $this->findOneBy(array("externalId" => $document->getId()));
    
        if(is_null($baseDocument))
        {
            $baseDocument = new Document();
            $baseDocument->setExternalId($document->getId());
        }
        $baseDocument->setDescription($document->getDescription());
        $baseDocument->setTitle($document->getTitle());
        
        $this->getEntityManager()->persist($baseDocument);
        $this->getEntityManager()->flush();
        return $baseDocument;
    
    }
    
    function removeDocument(DocumentInterface $document)
    {
        $baseDocument = $this->findOneBy(array("externalId" => $document->getId()));
        if(!is_null($baseDocument)) {
            $this->getEntityManager()->remove($baseDocument);
        }
    }
    
}