<?php
/*
 * This file is part of the WikiTagBundle package.
 *
 * (c) IRI <http://www.iri.centrepompidou.fr/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace IRI\Bundle\WikiTagBundle\Command;


use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Mandango\Mondator\Definition\Definition;
use Mandango\Mondator\Definition\Property;
use Mandango\Mondator\Definition\Method;
use Mandango\Mondator\Dumper;

class GenerateDocumentClassCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        parent::configure();
        
        $this
            ->setName('wikitag:generate-document-class')
            ->setDescription('Generate the document class document class')
            ->addArgument('path', InputArgument::OPTIONAL, 'The generation path')
            ->addOption("simulate","S",InputOption::VALUE_NONE, "Simulate generation");
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $path = $input->getArgument('path');
        if(is_null($path) || strlen($path) == 0)
        {
            $path = realpath($this->getContainer()->get('kernel')->getRootDir()."/../src");
        }
        
        $definition = new Definition('IRI\Bundle\WikiTagBundle\Entity\Document');
        
        $definition->setParentClass('IRI\Bundle\WikiTagBundle\Model\Document');
        
        $fields = $this->getContainer()->getParameter('wiki_tag.fields');
        foreach ( $fields as $name => $field_def)
        {
            $property = new Property("private", $name, NULL);
            $definition->addProperty($property);
            
            $get_method = new Method("public", "get".ucfirst($name), NULL, <<<EOF
                return \$this->$name;
EOF
            );
            $definition->addMethod($get_method);
            
            $set_method = new Method("public", "set".ucfirst($name), "\$$name", <<<EOF
                \$this->$name = \$$name;
EOF
            );
            $definition->addMethod($set_method);
            
        }
                
        $dumper = new Dumper($definition);
        $classCode = $dumper->dump();
        
        if($input->getOption('simulate'))
        {
            $output->writeln($classCode);
        }
        else
        {
            $file = "$path/IRI/Bundle/WikiTagBundle/Entity/Document.php";
            $output->writeln("Creating IRI\\Bundle\\WikiTagBundle\\Entity\\Document in $file");
            
            if(!file_exists(dirname($file)) && !mkdir(dirname($file),0777,true))
            {
                $output->writeln("Impossible to create folder exitiing.");
                die;
            }
            file_put_contents($file, $classCode);
        }

    }
}