<?php
/*
 * This file is part of the WikiTagBundle package.
 *
 * (c) IRI <http://www.iri.centrepompidou.fr/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace IRI\Bundle\WikiTagBundle\Model;

abstract class Document implements BaseDocumentInterface {
    
    /**
    * @var integer $id
    */
    protected $id;
    
    /**
     * @var string $title
     */
    protected $title;
    
    /**
     * @var text $description
     */
    protected $description;
    
    /**
     * @var boolean $manualOrder
     */
    protected $manualOrder = false;
    
    /**
     * @var string $externalId
     */
    protected $externalId;
    
    
    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }
    
    /**
     * Set title
     *
     * @param string $title
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }
    
    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
    
    /**
     * Set description
     *
     * @param text $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }
    
    /**
     * Get description
     *
     * @return text
     */
    public function getDescription()
    {
        return $this->description;
    }
    
    /**
    * Set manualOrder
    *
    * @param boolean $manualOrder
    */
    function setManualOrder($manualOrder)
    {
        $this->manualOrder = $manualOrder;
    }
    
    /**
     * Get manualOrder
     *
     * @return boolean
     */
    function getManualOrder()
    {
        return $this->manualOrder;
    }
    
    /**
     * TODO: (non-PHPdoc)
     * @see IRI\Bundle\WikiTagBundle\Model.BaseDocumentInterface::setExternalId()
     */
    function setExternalId($externalId)
    {
        $this->externalId = $externalId;
    }
    
    /**
     * TODO: (non-PHPdoc)
     * @see IRI\Bundle\WikiTagBundle\Model.BaseDocumentInterface::getExternalId()
     */
    function getExternalId()
    {
        return $this->externalId;
    }
    
}
