<?php
/*
 * This file is part of the WikiTagBundle package.
 *
 * (c) IRI <http://www.iri.centrepompidou.fr/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace IRI\Bundle\WikiTagBundle\Entity;

use Doctrine\Common\EventSubscriber;
use Doctrine\ORM\Events;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use IRI\Bundle\WikiTagBundle\Model\DocumentInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;


/**
 * Doctrine ORM listener updating the document index
 *
 * @author ymh
 *
 */
class DocumentListener implements EventSubscriber
{
    
    /**
    * @var ContainerInterface
    */
    private $container;
    
    /**
     * Constructor
     *
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        $this->container = $container;
    }
    
    public function getSubscribedEvents()
    {
        return array(
        Events::postPersist,
        Events::postUpdate,
        Events::preRemove,
        );
    }
    
    public function postPersist(LifecycleEventArgs $args)
    {
        $logger = $this->container->get('logger');
        $logger->debug("HandleEvent : PERSISTS");
        $this->handleEvent($args);
        
    }
    
    public function postUpdate(LifecycleEventArgs $args)
    {
        $logger = $this->container->get('logger');
        $logger->debug("HandleEvent : UPDATE");
        $this->handleEvent($args);
    }

    public function preRemove(LifecycleEventArgs $args)
    {
        $logger = $this->container->get('logger');
        $logger->debug("HandleEvent : REMOVE");
        $entity = $args->getEntity();
        if ($entity instanceof DocumentInterface && !($entity instanceof Document))
        {
            $this->container->get('doctrine')->getRepository("WikiTagBundle:Document")->removeDocument($entity);
        }
    }
    
    
    private function handleEvent(LifecycleEventArgs $args)
    {
//         if (null === $this->userManager) {
//             $this->userManager = $this->container->get('fos_user.user_manager');
//         }
        
        $logger = $this->container->get('logger');
        $logger->debug("HandleEvent : HELLO############");
        
        
        $entity = $args->getEntity();
        if ($entity instanceof DocumentInterface && !($entity instanceof Document))
        {
            $logger->debug("treating document : " . $entity->getTitle());
            $this->container->get('doctrine')->getRepository("WikiTagBundle:Document")->writeDocument($entity);
        }
        
    }
    
    
}