<?php

namespace IRI\Bundle\WikiTagBundle\Entity;

use Doctrine\ORM\EntityRepository;
use IRI\Bundle\WikiTagBundle\Utils\WikiTagUtils;
use IRI\Bundle\WikiTagBundle\Entity\Tag;

/**
 * TagRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class TagRepository extends EntityRepository
{
    public function getTagCloud($max_tags)
    {
        $qb = $this->getEntityManager()->createQueryBuilder();
        $qb->select('t.id', 't.label', 'COUNT( dt.id ) AS nb_docs');
        $qb->from('WikiTagBundle:Tag','t');
        $qb->leftJoin('t.documents', 'dt', 'WITH', 't = dt.tag');
        $qb->addGroupBy('t.id');
        $qb->addOrderBy('nb_docs','DESC');
        $qb->setMaxResults($max_tags);
        
        $query = $qb->getQuery();
        return $query->getResult();
    }
    
    public function getCompletion($seed)
    {
        $qb = $this->getEntityManager()->createQueryBuilder();
        $qb->select('t.label');
        $qb->from('WikiTagBundle:Tag','t');
        $qb->where($qb->expr()->orx(
            $qb->expr()->like('t.label',$qb->expr()->literal(addcslashes(mysql_real_escape_string($seed),"%_")."%")),
            $qb->expr()->like('t.label',$qb->expr()->literal("%".addcslashes(mysql_real_escape_string($seed),"%_"))),
            $qb->expr()->like('t.label',$qb->expr()->literal("% ".addcslashes(mysql_real_escape_string($seed),"%_")."%"))
        ));
        
        $query = $qb->getQuery();
        
        return $query->getResult();
        
    }
    
    /**
    * Get or create tag. Returns an array(tag:WikiTagTag, revision_id=int, created:Boolean)
    * @param $tag_label
    * @param $doctrine
    * @return multitype:boolean Ambigous <NULL, \IRI\Bundle\WikiTagBundle\Entity\Tag> Ambigous <NULL, unknown, mixed, string> (array(\IRI\Bundle\WikiTagBundle\Model\TagInterface, revision_id=int, created:Boolean))
    */
    public function getOrCreateTag($tag_label)
    {
        $tag_label_normalized = WikiTagUtils::normalizeTag($tag_label);
        // We get the wikipedia references for the tag_label
        // We get or create the tag object
        $tags = $this->findBy(array('normalizedLabel' => $tag_label_normalized));
        $tag = null;
        foreach ($tags as $t) {
            if($tag==null
            || $tag->getUrlStatus() === Tag::$TAG_URL_STATUS_DICT['unsemantized']
            || ($tag->getUrlStatus() === Tag::$TAG_URL_STATUS_DICT['null_result'] && $t->getUrlStatus() !== Tag::$TAG_URL_STATUS_DICT['unsemantized'])) {
                $tag = $t;
                if($tag->getUrlStatus()!=Tag::$TAG_URL_STATUS_DICT['unsemantized'] && $tag->getUrlStatus()!=Tag::$TAG_URL_STATUS_DICT['null_result']) {
                    break;
                }
            }
        }
        $wp_request_done = false;
        if($tag==null) {
            $tag = new Tag();
            $tag->setLabel($tag_label_normalized);
            $tag->setOriginalLabel($tag_label);
            $tag->setNormalizedLabel($tag_label_normalized);
            $created = true;
        }
        else {
            $created = false;
        }
    
        // We request Wikipedia if the tag is created or if this is a null result
        if($created==true || $tag->getUrlStatus()===Tag::$TAG_URL_STATUS_DICT['null_result']) {
            
            if($wp_request_done==false) {
                $wp_response = WikiTagUtils::getWikipediaInfo($tag_label_normalized);
            }
            
            $tag->setWikipediaInfo($wp_response);
    
            // Save datas.
            $em = $this->getEntityManager();
            $em->persist($tag);
            $em->flush();
                
            $wikipedia_revision_id = $wp_response['revision_id'];
    
        }
        elseif($tag!=null && $tag->getWikipediaPageId()!=null) {
            $wp_response = WikiTagUtils::getWikipediaInfo(null, $tag->getWikipediaPageId());
            $wikipedia_revision_id = $wp_response['revision_id'];
        }
        else {
            $wikipedia_revision_id = null;
        }
    
        return array($tag, $wikipedia_revision_id, $created);//, $wpReponse);
    }
    
}
