<?php
/*
 * This file is part of the WikiTagBundle package.
 *
 * (c) IRI <http://www.iri.centrepompidou.fr/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace IRI\Bundle\WikiTagBundle\Entity;

use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\Query;

use Doctrine\ORM\QueryBuilder;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\NoResultException;

/**
 * DocumentTagRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class DocumentTagRepository extends EntityRepository
{
   /**
    * Find ordered document tags by document id.
    * Allow to control the hydration mode of the returned data (c.f. Doctrine\ORM\AbstractQuery::HYDRATE_*)
    *
    * @param mixed $doc_id The document id
    * @param int   $hydrationMode Value from Doctrine\ORM\AbstractQuery::HYDRATE_*. 
    * @return array (c.f from Doctrine\ORM\AbstractQuery::get_result())
    */
    public function findOrderedTagsForDoc($doc_id, $hydrationMode=AbstractQuery::HYDRATE_OBJECT)
    {
        return $this->getEntityManager()
        ->createQuery("SELECT doctag, tag FROM WikiTagBundle:DocumentTag doctag JOIN doctag.tag tag JOIN doctag.document doc WHERE doc.externalId=:doc_id ORDER BY doctag.tagOrder ASC")
        ->setParameter("doc_id", strval($doc_id))
        ->getResult($hydrationMode);
    }
    
    private function findMaxOrderInUow($entityList, $doc_id, $max_order) {
        foreach($entityList as $entity) {
            if(is_a($entity, "\IRI\Bundle\WikiTagBundle\Model\DocumentTagInterface") &&
            !is_null($entity->getDocument()) &&
            ( $entity->getDocument() === $doc_id || $entity->getDocument()->getId() === $doc_id ) )
            {
                $max_order = max(array($max_order, $entity->getTagOrder()));
            }
        }
        return $max_order;
    }
    
        
    /**
     *  Gets the max order of all tags for one document
     */
    public function getMaxOrder($doc_id)
    {
        $max_order_res = $this->getEntityManager()
            ->createQuery("SELECT MAX(doctag.tagOrder) FROM WikiTagBundle:DocumentTag doctag JOIN doctag.document doc WHERE doc.externalId= :doc_id")
            ->setParameter("doc_id", strval($doc_id))
            ->getSingleScalarResult();
        
        $max_order = 0;
        if(!is_null($max_order_res)) {
            $max_order = intval($max_order_res);
        }
        
        $uow = $this->getEntityManager()->getUnitOfWork();
        
        $max_order = $this->findMaxOrderInUow($uow->getScheduledEntityInsertions(), $doc_id, $max_order);
        $max_order = $this->findMaxOrderInUow($uow->getScheduledEntityUpdates(), $doc_id, $max_order);

        return $max_order;
    }
    
    /**
     *
     * Enter description here ...
     * @param unknown_type $external_id
     * @param array $filter_array
     * @return QueryBuilder
     */
    private function createQueryBuilderByDocumentExternalId($external_id, array $filter_array=null) {
        $qb = $this->createQueryBuilder("dt")
        ->join('dt.document', 'd')
        ->where('d.externalId = :external_id');

        $params = array("external_id"=>strval($external_id));
        
        if(!is_null($filter_array)) {
            foreach ($filter_array as $key => $value) {
                $qb = $qb->andWhere("dt.$key = :$key");
                //$params[$key] = $value;
            }
            $params = array_merge($params, $filter_array);
        }
        
        $qb = $qb->setParameters($params);
        
        return $qb;
    }
    
    /**
     *
     * Enter description here ...
     * @param unknown_type $external_id
     * @param array $filter_array
     */
    public function findByDocumentExternalId($external_id, array $filter_array=null)
    {
        $qb = $this->createQueryBuilderByDocumentExternalId($external_id, $filter_array);
        return $qb->getQuery()->getResult();
    }
    
   	/**
     *
     * Enter description here ...
     * @param unknown_type $external_id
     * @param array $filter_array
     */
    public function findOneByDocumentExternalId($external_id, array $filter_array=null) {
        
        $qb = $this->createQueryBuilderByDocumentExternalId($external_id, $filter_array)->setMaxResults(1);
        
        try {
            return $qb->getQuery()->getSingleResult();
        } catch (NoResultException $e) {
            return null;
        }
    }

}
