<?php
/*
 * This file is part of the WikiTagBundle package.
 *
 * (c) IRI <http://www.iri.centrepompidou.fr/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace IRI\Bundle\WikiTagBundle\Command;


use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Mandango\Mondator\Definition\Definition;
use Mandango\Mondator\Definition\Property;
use Mandango\Mondator\Definition\Method;
use Mandango\Mondator\Dumper;

class CreateFullTextIndexesCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        parent::configure();
        
        $this
            ->setName('wikitag:create-fulltext-indexes')
            ->setDescription('Generate the full text indexes for the document table')
            ->addArgument('path', InputArgument::OPTIONAL, 'The generation path')
            ->addOption("simulate","S",InputOption::VALUE_NONE, "Simulate generation");
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $file = $input->getArgument('path');
        $simulate = $input->getOption('simulate');
        if(is_null($file) || strlen($file) == 0)
        {
            $simulate = true;
        }
        
        $sql_code = "";
        $fields = $this->getContainer()->getParameter('wiki_tag.fields');
        $def_columns = array();
        foreach ( $fields as $name => $field_def)
        {
            if(isset($field_def['type']))
            {
                $type = $field_def['type'];
            }
            if(!isset($type) || is_null($type) || strlen($type) == 0)
            {
                $type = "text";
            }
            
            if($type === 'text')
            {
                $def_column = "$name(4096)";
            }
            else
            {
                $def_column = $name;
            }
            $def_columns[] = $def_column;
            
            $sql_code .= "ALTER IGNORE TABLE wikitag_document DROP INDEX ${name}_document_fulltext_idx;\n";
            $sql_code .= "ALTER TABLE wikitag_document ADD FULLTEXT INDEX ${name}_document_fulltext_idx ($def_column);\n";
        }
        
        $sql_code .= "ALTER IGNORE TABLE wikitag_document DROP INDEX all_document_fulltext_idx;\n";
        $sql_code .= "ALTER TABLE wikitag_document ADD FULLTEXT INDEX all_document_fulltext_idx (".join(",", $def_columns).");\n";
        
        
        if($simulate)
        {
            $output->writeln($sql_code);
        }
        else
        {
            $output->writeln("Creating Indexes in $file");
            
            if(!file_exists(dirname($file)) && !mkdir(dirname($file),0777,true))
            {
                $output->writeln("Impossible to create folder exitiing.");
                die;
            }
            file_put_contents($file, $sql_code);
        }

    }
}