<?php
/*
 * This file is part of the WikiTagBundle package.
*
* (c) IRI <http://www.iri.centrepompidou.fr/>
*
* For the full copyright and license information, please view the LICENSE
* file that was distributed with this source code.
*/

namespace IRI\Bundle\WikiTagBundle\Controller;

use IRI\Bundle\WikiTagBundle\Entity\DocumentTag;
use IRI\Bundle\WikiTagBundle\Entity\Tag;
use IRI\Bundle\WikiTagBundle\Utils\WikiTagUtils;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;


class WikiTagController extends Controller
{
    /**
     * Fake index action
     */
    public function indexAction()
    {
        return new Response('<html><body>Nothing to see here.</body></html>');
    }

    /**
     * Renders the little html to add the css
     */
    public function addCssAction()
    {
        return $this->render('WikiTagBundle:WikiTag:css.html.twig');
    }

    /**
     * Renders the little html to add the javascript
     * TODO: review why this injection in javascript, t10n?
     */
    public function addJavascriptAction()
    {
        $cats = $this->getDoctrine()->getRepository('WikiTagBundle:Category')->findOrderedCategories();
        // $cats is {"Label":"Créateur"},{"Label":"Datation"},...
        $nbCats = count($cats);
        $ar = array('' => '');
        for($i=0;$i<$nbCats;$i++){
            $temp = array($cats[$i]["Label"] => $cats[$i]["Label"]);
            $ar = array_merge($ar, $temp);
        }
        // ... so we create is json like {"":""},{"Créateur":"Créateur"},{"Datation":"Datation"},...
        $categories = json_encode($ar);
        return $this->render('WikiTagBundle:WikiTag:javascript.html.twig', array('categories' => $categories));
    }

    /**
     * List all tags for doc
     * TODO: doc_id as parameter
     * TODO: Is this controller usefull ?
     */
    public function allTagsAction()
    {
        $ordered_tags = $this->getDoctrine()->getRepository('WikiTagBundle:DocumentTag')->findAll();
        return $this->render('WikiTagBundle:WikiTag:documentTags.html.twig', array('ordered_tags' => $ordered_tags, 'doc_id' => 1));
    }

    /**
     * Display a list of ordered tag for a document
     * @param integer $id_doc
     */
    public function documentTagsAction($id_doc)
    {
        $ordered_tags = $this->getDoctrine()->getRepository('WikiTagBundle:DocumentTag')->findOrderedTagsForDoc($id_doc);
        return $this->render('WikiTagBundle:WikiTag:documentTags.html.twig', array('ordered_tags' => $ordered_tags, 'doc_id' => $id_doc));
    }

    /**
     *
     * TODO : Enter description here ...
     * @return \Symfony\Bundle\FrameworkBundle\Controller\Response
     */
    public function tagUpDownAction()
    {

        $req = $this->getRequest()->request;
        $id_doc = $req->get('wikitag_document_id');
        // post vars new_order and old_order indicate the position (from 1) of the tag in the list.
        // NB : it is different from the DocumentTag.order in the database.
        $new_order = intval($req->get('new_order')) - 1;
        $old_order = intval($req->get('old_order')) - 1;
        // First we get the DocumentTags
        $em = $this->getDoctrine()->getEntityManager();
        $ordered_tags = $this->getDoctrine()->getRepository('WikiTagBundle:DocumentTag')->findOrderedTagsForDoc($id_doc);
        // We change the moved DocumentTag's order
        $new_dt_order = $ordered_tags[$new_order]->getTagOrder();
        $moved_dt = $ordered_tags[$old_order];
        $moved_dt->setTagOrder($new_dt_order);
        // We move the TaggedSheets's order
        if($new_order > $old_order){
            // And we decrease the other ones
            for ($i=($old_order+1); $i <= ($new_order); $i++){
                $dt = $ordered_tags[$i];
                $dt->setTagOrder($dt->getTagOrder() - 1);
            }
        }
        else{
            // And we increase the other ones
            for ($i=$new_order; $i <= ($old_order-1); $i++){
                $dt = $ordered_tags[$i];
                $dt->setTagOrder($dt->getTagOrder() + 1);
            }
        }
        // Save datas.
        $em->flush();

        return $this->renderDocTags($id_doc);
    }

    /**
     *
     * TODO: Enter description here ...
     * @return \Symfony\Bundle\FrameworkBundle\Controller\Response
     */
    public function removeTagFromListAction()
    {
        $id_doc = $this->getRequest()->request->get('wikitag_document_id');
        $id_tag = $this->getRequest()->request->get('tag_id');
        // We get the DocumentTag meant to be deleted, and remove it.
        $em = $this->getDoctrine()->getEntityManager();
        $dt = $this->getDoctrine()->getRepository('WikiTagBundle:DocumentTag')->findOneBy(array('tag' => $id_tag, 'document' => $id_doc));
        $em->remove($dt);
        $em->flush();

        return $this->renderDocTags($id_doc);
    }

    /**
     *
     * TODO: Enter description here ...
     */
    public function modifyDocumentTagAction()
    {
        $id_doc = $this->getRequest()->request->get('wikitag_document_id');
        $tag_label = $this->getRequest()->request->get('value');
        $id_moved_tag = $this->getRequest()->request->get('id');
        $moved_tag = $this->getDoctrine()->getRepository('WikiTagBundle:Tag')->findOneBy(array('id' => $id_moved_tag));
        if($tagLabel!=$movedTag->getLabel()){
            // We get the DocumentTags
            $em = $this->getDoctrine()->getEntityManager();
            $tags = $this->getDoctrine()->getRepository('WikiTagBundle:DocumentTag')->findBy(array('document' => $id_doc));
            $nb_tags = count($tags);
            $found = false;
            $i = 0;
            while($i<$nb_tags && $found==false){
                $dt = $tags[$i];
                if(strtolower($dt->getTag()->getLabel())==strtolower($tag_label)){
                    $found = true;
                }
                $i++;
            }
            // If the label was found, we sent a bad request
            if($found==true){
                return new Response(json_encode(array('error' => 'duplicate_tag', 'message' => sprintf("Le tag %s existe déjà pour cette fiche.", $tag_label))),400);
            }
            // We create the new tag or get the already existing tag. $tag, $revision_id, $created
            $ar = WikiTagUtils::getOrCreateTag($tag_label, $this->getDoctrine());// tag, revision_id, created = get_or_create_tag(tag_label)
            $tag = $ar[0];
            $revision_id = $ar[1];
            $created = $ar[2];
            // We get the DocumentTag and change its tag
            $dt = $this->getDoctrine()->getRepository('WikiTagBundle:WikiTagDocumentTag')->findOneBy(array('document' => $id_doc, 'tag' => $id_moved_tag));
            $dt->setTag($tag);
            $dt->setWikipediaRevisionId($revision_id);
            //
            // HERE QUERY TO GET A INDEX_NOTE/SCORE for the tag. Here is python code :
            //kwargs = {DJANGO_ID + "__exact": unicode(ds_id)}
            //results = SearchQuerySet().filter(title=tag_label).filter_or(description=tag_label).filter(**kwargs)
            //if len(results) > 0:
            //    ts.index_note = results[0].score
            //
            // We save the datas
            $doc = $this->getDoctrine()->getRepository('WikiTagBundle:Document')->findOneBy(array('id' => $id_doc));
            $doc->setManualOrder(true);
            $em->flush();
        }

        return $this->renderDocTags($id_doc);
    }

    /**
     *
     * TODO: Enter description here ...
     */
    public function resetWpInfoAction()
    {
        $id_doc = $this->getRequest()->request->get('wikitag_document_id');
        return $this->renderDocTags($id_doc);
    }

    /**
     *
     * TODO : Enter description here ...
     */
    public function reorderTagDocumentAction()
    {
        $id_Doc = $this->getRequest()->request->get('wikitag_document_id');
        return $this->renderDocTags($id_doc);
    }

    /**
     *
     * TODO: Enter description here ...
     */
    public function addTagAction()
    {
        $id_doc = $this->getRequest()->request->get('wikitag_document_id');
        $tag_label = $this->getRequest()->request->get('value');
        // We get the DocumentTags
        $em = $this->getDoctrine()->getEntityManager();
        $tags = $this->getDoctrine()->getRepository('WikiTagBundle:DocumentTag')->findByDocumentExternalId($id_doc);
        $nb_tags = count($tags);
        $found = false;
        $i = 0;
        while($i<$nb_tags && $found==false){
            $dt = $tags[$i];
            if(strtolower($dt->getTag()->getLabel())==strtolower($tag_label)){
                $found = true;
            }
            $i++;
        }
        // If the label was found, we sent a bad request
        if($found==true){
            //TODO : translation
            return new Response(json_encode(array('error' => 'duplicate_tag', 'message' => sprintf("Le tag %s existe déjà pour cette fiche.", $tag_label))),400);
        }
        // $tag, $revision_id, $created
        $ar = WikiTagUtils::getOrCreateTag($tag_label, $this->getDoctrine());// tag, revision_id, created = get_or_create_tag(tag_label)

        $tag = $ar[0];
        $revision_id = $ar[1];
        $created = $ar[2];

        $tags = $this->getDoctrine()->getRepository('WikiTagBundle:DocumentTag')->findByDocumentExternalId($id_doc, array('tag'=>$tag->getId()));
        $nb_tags = count($tags);

        if($created==true || $nb_tags==0){
            $new_order_ar = $this->getDoctrine()->getRepository('WikiTagBundle:DocumentTag')->getMaxOrder($id_doc);
            // The result is a double array. And reset(reset($newOrderAr)) is not allowed. And a string is returned.
            $a1 = reset($new_order_ar);
            $new_order = intval(reset($a1)) + 1;
            // TODO: use a factory that returns an DocumentTagInterface
            $new_DT = new DocumentTag();
            $new_DT->setDocument($this->getDoctrine()->getRepository('WikiTagBundle:Document')->findOneByExternalId($id_doc));
            $new_DT->setTag($tag);
            $new_DT->setOriginalOrder($new_order);
            $new_DT->setTagOrder($new_order);
            $new_DT->setWikipediaRevisionId($revision_id);
            $em->persist($new_DT);
            $em->flush();
        }

        return $this->renderDocTags($id_doc);
    }


    /**
     *
     * TODO: Enter description here ...
     * @return \Symfony\Bundle\FrameworkBundle\Controller\Response
     */
    public function removeWpLinkAction()
    {
        $id_doc = $this->getRequest()->request->get('wikitag_document_id');
        $id_tag = $this->getRequest()->request->get('tag_id');
        $tag = $this->getDoctrine()->getRepository('WikiTagBundle:Tag')->find($id_tag);
        //return new Response(var_dump(array($tag)));
        // We search if the unsemantized version of the tag already exist.
        $un_tag = $this->getDoctrine()->getRepository('WikiTagBundle:Tag')->findOneBy(array('label'=>$tag->getLabel(), 'urlStatus'=>Tag::$TAG_URL_STATUS_DICT['null_result']));
        $em = $this->getDoctrine()->getEntityManager();
        if(!$un_tag){
            // Create another tag almost identical, without the W info
            // TODO: use a factory that return a TagInterface
            $un_tag = new Tag();
            $un_tag->setLabel($tag->getLabel());
            $un_tag->setOriginalLabel($tag->getOriginalLabel());
            $un_tag->setUrlStatus(Tag::$TAG_URL_STATUS_DICT['null_result']);
            $un_tag->setWikipediaUrl(null);
            $un_tag->setWikipediaPageId(null);
            $un_tag->setDbpediaUri(null);
            $un_tag->setCategory($tag->getCategory());
            $un_tag->setAlias($tag->getAlias());
            $un_tag->setPopularity($tag->getPopularity());
            $em->persist($un_tag);
        }
        // We associate the unsemantized tag to the DocumentTag and save datas
        // TODO: do the request on external id of document
        $dt = $this->getDoctrine()->getRepository('WikiTagBundle:DocumentTag')->findOneByDocumentExternalId($id_doc, array('tag' => $idTag));
        $dt->setTag($un_tag);
        $em->flush();
        
        return $this->renderDocTags($id_doc);
    }


    /**
     *
     * TODO : Enter description here ...
     * TODO : implement
     * @return \Symfony\Bundle\FrameworkBundle\Controller\Response
     */
    public function updateTagAliasAction()
    {
        $id_doc = $this->getRequest()->request->get('wikitag_document_id');
        return $this->renderDocTags($id_doc);
    }


    /**
     *
     * TODO: Enter description here ...
     */
    public function updateTagCategoryAction()
    {
        $id_doc = $this->getRequest()->request->get('wikitag_document_id');
        $id_tag = $this->getRequest()->request->get('id');
        $cat_label = $this->getRequest()->request->get('value');
        // We get the Tag and update its category.
        $em = $this->getDoctrine()->getEntityManager();
        $tag = $this->getDoctrine()->getRepository('WikiTagBundle:Tag')->find($id_tag);
        if($cat_label==''){
            $cat = null;
            $tag->nullCategory();
        }
        else{
            $cat = $this->getDoctrine()->getRepository('WikiTagBundle:Category')->findOneBy(array('label' => $cat_label));
            $tag->setCategory($cat);
        }
        $em->flush();

        return $this->renderDocTags($id_doc);
    }


    /**
     *
     * Generic render partial template
     * @param unknown_type $id_doc
     */
    public function renderDocTags($id_doc)
    {
        $ordered_tags = $this->getDoctrine()->getRepository('WikiTagBundle:DocumentTag')->findOrderedTagsForDoc($id_doc);
        return $this->render('WikiTagBundle:WikiTag:tagTable.html.twig', array('ordered_tags' => $ordered_tags, 'doc_id' => $id_doc));
    }


}