<?php

namespace IRI\Bundle\WikiTagBundle\Entity;

use Doctrine\ORM\Query;

use Doctrine\ORM\QueryBuilder;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\NoResultException;

/**
 * DocumentTagRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class DocumentTagRepository extends EntityRepository
{
    /**
    *  Find ordered tags by document id
    */
    public function findOrderedTagsForDoc($doc_id)
    {
        return $this->getEntityManager()
        ->createQuery("SELECT doctag FROM WikiTagBundle:DocumentTag doctag JOIN doctag.document doc WHERE doc.externalId=:doc_id ORDER BY doctag.tagOrder ASC")
        ->setParameter("doc_id", strval($doc_id))
        ->getResult();
    }
    
    /**
     *  Gets the max order of all tags for one document
     */
    public function getMaxOrder($doc_id)
    {
        return $this->getEntityManager()
        ->createQuery("SELECT MAX(doctag.tagOrder) FROM WikiTagBundle:DocumentTag doctag JOIN doctag.document doc WHERE doc.externalId= :doc_id")
        ->setParameter("doc_id", strval($doc_id))
        ->getResult();
    }
    
    
    /**
     *
     * Enter description here ...
     * @param unknown_type $external_id
     * @param array $filter_array
     * @return QueryBuilder
     */
    private function createQueryBuilderByDocumentExternalId($external_id, array $filter_array=null) {
        $qb = $this->createQueryBuilder("dt")
        ->join('dt.document', 'd')
        ->where('d.externalId = :external_id');

        $params = array("external_id"=>strval($external_id));
        
        if(!is_null($filter_array)) {
            foreach ($filter_array as $key => $value) {
                $qb = $qb->where("dt.$key = :p_$key");
                $params["p_$key"] = $value;
            }
        }
        
        $qb = $qb->setParameters($params);
        
        return $qb;
    }
    
    public function findByDocumentExternalId($external_id, array $filter_array=null)
    {
        $qb = $this->createQueryBuilderByDocumentExternalId($external_id, $filter_array);
        return $qb->getQuery()->getResult();
    }
    
    public function findOneByDocumentExternalId($external_id, array $filter_array=null) {
        
        $qb = $this->createQueryBuilderByDocumentExternalId($external_id, $filter_array)->setMaxResults(1);
        
        try {
            return $qb->getQuery()->getSingleResult();
        } catch (NoResultException $e) {
            return null;
        }
    }
    
}