<?php
/*
 * This file is part of the WikiTagBundle package.
 *
 * (c) IRI <http://www.iri.centrepompidou.fr/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace IRI\Bundle\WikiTagBundle\Model;

abstract class Document implements DocumentInterface {
    
    /**
    * @var integer $id
    */
    protected $id;
    
    /**
     * @var string $title
     */
    protected $title;
    
    /**
     * @var text $description
     */
    protected $description;
    
    /**
     * @var boolean $manualOrder
     */
    protected $manualOrder;
    
    
    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }
    
    /**
     * Set title
     *
     * @param string $title
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }
    
    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }
    
    /**
     * Set description
     *
     * @param text $description
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }
    
    /**
     * Get description
     *
     * @return text
     */
    public function getDescription()
    {
        return $this->description;
    }
    
    /**
    * Set manualOrder
    *
    * @param boolean $manualOrder
    */
    function setManualOrder($manualOrder)
    {
        $this->manualOrder = $manualOrder;
    }
    
    /**
     * Get manualOrder
     *
     * @return boolean
     */
    function getManualOrder()
    {
        return $this->manualOrder;
    }
    
    
}
