<?php
/*
 * This file is part of the WikiTagBundle package.
 *
 * (c) IRI <http://www.iri.centrepompidou.fr/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace IRI\Bundle\WikiTagBundle\Services;
 
use Symfony\Component\DependencyInjection\ContainerAware;
use Symfony\Component\DependencyInjection\ContainerInterface;

class DocumentService extends ContainerAware
{
    /**
     * Get the container associated with this service.
     * @return ContainerInterface
     */
    public function getContainer()
    {
        return $this->container;
    }
    
    /**
     * Public constructor with container as parameter for contruct injection.
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        $this->setContainer($container);
    }
    
    private $doctrine;
    
    public function getDoctrine()
    {
        if(is_null($this->doctrine))
        {
            $this->doctrine = $this->getContainer()->get('doctrine');
        }
        return $this->doctrine;
    }
    

    /**
     * Copy the list of tags of one document to another.
	 *
     * @param mixed $id_doc_src the source document id
     * @param mixed $id_doc_tgt the target document id
     */
    public function copyTags($id_doc_src, $id_doc_tgt)
    {
        
        $doctrine = $this->getDoctrine();
        $em = $doctrine->getEntityManager();
        
        $doc_rep = $em->getRepository("WikiTagBundle:Document");
        
        $src_doc = $doc_rep->findOneByExternalId($id_doc_src);
        if(is_null($src_doc))
        {
            throw new Exception("cloneTags: no source doc");
        }
        
        $tgt_doc = $doc_rep->findOneByExternalId($id_doc_tgt);
        if(is_null($tgt_doc))
        {
            throw new Exception("cloneTags: no target doc");
        }
        
        
        $doc_rep->copyTags($src_doc, $tgt_doc);
        
        $em->flush();
        
    }
    
        
}