<?php
/*
 * This file is part of the WikiTagBundle package.
 *
 * (c) IRI <http://www.iri.centrepompidou.fr/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace IRI\Bundle\WikiTagBundle\Search;
 
use Symfony\Component\DependencyInjection\ContainerAware;
use Symfony\Component\DependencyInjection\ContainerInterface;

class Search extends ContainerAware
{
    /**
     * Get the container associated with this service.
     * @return ContainerInterface
     */
    public function getContainer()
    {
        return $this->container;
    }
    
    /**
     * Public constructor with container as parameter for contruct injection.
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        $this->setContainer($container);
    }
    
    private $doctrine;
    
    public function getDoctrine()
    {
        if(is_null($this->doctrine))
        {
            $this->doctrine = $this->getContainer()->get('doctrine');
        }
        return $this->doctrine;
    }
    /**
     *
     * Enter description here ...
     * @param string $value
     * @param array $conditions
     * @param array $fields
     */
    public function search($value, array $conditions, array $fields=null)
    {
        if(is_null($fields))
        {
            $fields = $this->getContainer()->getParameter("wiki_tag.fields");
        }
        $doctrine = $this->getContainer()->get('doctrine');
        $res = $doctrine->getRepository('WikiTagBundle:Document');
        $fieldquery = array();
        foreach ($fields as $fieldname => $fielddef) {
            if(isset($fielddef['weight']))
            {
                $weight = $fielddef['weight'];
            }
            else
            {
                $weight = 1.0;
            }
            $fieldquery[] = array("columns"=>$fieldname, "value"=>$value, "weight"=>$weight);
        }
        
        $score_res = $res->search($fieldquery, $conditions);
        
        return $score_res;
    }
    
    /**
     * Service to reorder the tags using their notes in the index search
     * @param IRI\Bundle\WikiTagBundle\Model\DocumentInterface $document
     */
    public function reorderTagsForDocument($document)
    {
        $doctrine = $this->getContainer()->get('doctrine');
        
        $tags_score = array();
        
        foreach($document->getTags() as $tag)
        {
            $label = $tag->getTag()->getLabel();
            
            $score_res = $this->search($label, array("id"=>$document->getId()));
            
            if(count($score_res)>0)
            {
                $score = floatval($score_res[0]['score']);
            }
            else
            {
                $score = 0.0;
            }
            $tags_score[] = array($score,$tag);
        }
        // sort tags based on score
        $i=1;
        usort($tags_score, function($a, $b) {
            return $a[0]<$b[0]?1:-1;
        });

        foreach($tags_score as $item)
        {
            $tag = $item[1];
            $tag->setTagOrder($i++);
            $tag->setIndexNote($item[0]);
            $doctrine->getEntityManager()->persist($tag);
        }
        
    }
    
    public function getTagCloud($max_tags)
    {
        $rep = $this->getDoctrine()->getRepository('WikiTagBundle:Tag');
        return $rep->getTagCloud($max_tags);
    }
    
    public function completion($seed)
    {
        $rep = $this->getDoctrine()->getRepository('WikiTagBundle:Tag');
        
        $res = array();
        foreach ($rep->getCompletion($seed) as $value) {
            $res[] = $value['label'];
        }
        
        return $res;
        
    }
    
        
}