﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Controls.ViewModel;
namespace Iri.Modernisation.Controls.View
{
    
    public partial class CustomableVideoElement : UserControl
    {
        public double TrimLeft
        {
            get { return (double)GetValue(TrimLeftProperty); }
            set
            {
               
                if(((CustomableVideoElementVM)DataContext).BeginTrim.Add(new TimeSpan(0, 0, 0, 0, (int)((value) / ProductionTimeLine.ScaleTime))) >= TimeSpan.Zero)
                {
                    SetValue(TrimLeftProperty, value);
                    ((CustomableVideoElementVM)DataContext).BeginTrim = ((CustomableVideoElementVM)DataContext).BeginTrim.Add(new TimeSpan(0, 0, 0, 0, (int)((value) / ProductionTimeLine.ScaleTime)));
                    if (((CustomableVideoElementVM)DataContext).Duration < 1)
                    {
                        ((CustomableVideoElementVM)DataContext).BeginTrim= ((CustomableVideoElementVM)DataContext).RunTime - ((CustomableVideoElementVM)DataContext).EndTrim -  TimeSpan.FromSeconds(1);

                    }
                    this.Width = ((CustomableVideoElementVM)DataContext).Duration  ;
                }
            }
        }
        public static readonly DependencyProperty TrimLeftProperty =
             DependencyProperty.Register("TrimLeft", typeof(double), typeof(CustomableVideoElement), null);




        public double  TrimRight
        {
            get { return (double )GetValue(TrimRightProperty); }
            set 
            { 
                if(((CustomableVideoElementVM)DataContext).EndTrim.Add(new TimeSpan(0, 0, 0, 0, (int)((value) / ProductionTimeLine.ScaleTime))) >= TimeSpan.Zero)
                {
                    SetValue(TrimRightProperty, value);
                    ((CustomableVideoElementVM)DataContext).EndTrim = ((CustomableVideoElementVM)DataContext).EndTrim.Add(new TimeSpan(0, 0, 0, 0, (int)((value) / ProductionTimeLine.ScaleTime)));

                    if (((CustomableVideoElementVM)DataContext).Duration<1)
                    {
                        ((CustomableVideoElementVM)DataContext).EndTrim = ((CustomableVideoElementVM)DataContext).RunTime -((CustomableVideoElementVM)DataContext).BeginTrim - TimeSpan.FromSeconds(1);
                    
                    }

                    
                        this.Width = ((CustomableVideoElementVM)DataContext).Duration;
                    
                }
            }
        }

        // Using a DependencyProperty as the backing store for TrimRight.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty TrimRightProperty =
            DependencyProperty.Register("TrimRight", typeof(double ), typeof(CustomableVideoElement),null);

            
         public CustomableVideoElement()
        {
            InitializeComponent();
   
        
        }

    }
}
