﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Threading;
namespace Iri.Modernisation.Data.Models
{

    
    /// <summary>
    /// 
    /// </summary>
    public static class SettingsProject
    {



        static public User ActualUser { get; set; }
        static public List<VideoBook> ListVideoBook { get; set; }
        static public List<VideoSequence> ProductionVideo { get; set; }
        static public Sync Synchronizer { get; set; }
        static SettingsProject()
        {
            ActualUser = new User() { UserName = "TestUser" };
            Synchronizer = new Sync();
            Synchronizer.Completed += new EventHandler<EventArgs>(Synchronizer_Completed);
        }

        static void Synchronizer_Completed(object sender, EventArgs e)
        {
            if (SettingsLoaded != null)
                SettingsLoaded(sender, e);
        }
        /// <summary>
        /// (Télé)Chargement des données;
        /// </summary>
        /// <param name="configFileURI"></param>
        static public void Load(String configFileURI)
        {
            FactoryVideoLivre.Initialize();
            FactoryVideoLivre.FactoryReady += new EventHandler(FactoryVideoLivre_FactoryReady);
            FactoryVideoLivre.LoadXMLFile(configFileURI);
            
        }

        /// <summary>
        /// Une fois que le fichier config du projet est chargé
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        static void FactoryVideoLivre_FactoryReady(object sender, EventArgs e)
        {
            
            Loader<List<VideoBook>> loaderListVideoBook = new Loader<List<VideoBook>>(VideoBook.GetListVideoBook);
            
            loaderListVideoBook.LoaderFinished += new EventHandler<EventArgs>(LoaderVideoBook_LoaderFinished);
            Synchronizer.RegisterLoader(loaderListVideoBook);
            

            Loader<List<VideoSequence>> loaderProductionVideo = new Loader<List<VideoSequence>>(VideoSequence.GetProductionVideo);
          
            loaderProductionVideo.LoaderFinished += new EventHandler<EventArgs>(loaderProductionVideo_LoaderFinished);
            Synchronizer.RegisterLoader(loaderProductionVideo);
            
            loaderProductionVideo.Load(FactoryVideoLivre.ProductionVideoPath);
            loaderListVideoBook.Load(FactoryVideoLivre.VideoBookListPath);

          
        }

        static void loaderProductionVideo_LoaderFinished(object sender, EventArgs e)
        {
            SettingsProject.ProductionVideo = ((LoaderEventArgs<List<VideoSequence>>)e).CreatedObject;
    
        }

       

        static void LoaderVideoBook_LoaderFinished(object sender, EventArgs e)
        {
            SettingsProject.ListVideoBook = ((LoaderEventArgs<List<VideoBook>>)e).CreatedObject;
           
        }
        /// <summary>
        /// Evenement prévenant quand tout est pret
        /// </summary>
        static public event EventHandler SettingsLoaded;
    }
}
