﻿using System.ComponentModel;

namespace Iri.Modernisation.BaseMVVM.ViewModel
{
    /// <summary>
    /// Base class for all view models 
    /// </summary>
    public abstract class ViewModel : INotifyPropertyChanged
    {

        public event PropertyChangedEventHandler PropertyChanged;


        protected virtual void OnPropertyChanged(string propertyName)
        {
            if (PropertyChanged != null)
            {
                PropertyChangedEventArgs _temp = new PropertyChangedEventArgs(propertyName);
                PropertyChanged(this,_temp);
            }
        }
    }
}
