﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class WebCamControlVM : BaseMVVM.ViewModel.ViewModel
    {


         private CaptureSource _captureSource {get;set;}
         public CaptureSource CaptureSource
         {
             get
             {
                 return _captureSource;
             }
             set
             {
                 _captureSource = value;
                 OnPropertyChanged("CaputreSource");
             }
         }
        public WebCamControlVM()
        {
            Commands.WebCamControl.CamRecordLanch.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(CamRecordLanch_Executed);
            Commands.WebCamControl.CamRecordStop.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(CamRecordStop_Executed);
            Commands.WebCamControl.CamRecordEnd.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(CamRecordEnd_Executed);
            Commands.WebCamControl.CamRecordBegin.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(CamRecordBegin_Executed);
		
        CaptureSource  = new CaptureSource()
            {
                VideoCaptureDevice = CaptureDeviceConfiguration.GetDefaultVideoCaptureDevice(),
                AudioCaptureDevice = CaptureDeviceConfiguration.GetDefaultAudioCaptureDevice()
            };
        }
        void CamRecordStop_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            _captureSource.Stop();
        }

        void CamRecordEnd_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {

        }

        void CamRecordLanch_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            if (CaptureDeviceConfiguration.AllowedDeviceAccess || CaptureDeviceConfiguration.RequestDeviceAccess())
            {
                _captureSource.Start();
            }
        }

        void CamRecordBegin_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {

        }
    }
}
