﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using Iri.Modernisation.Data.Models;
namespace Iri.Modernisation.Controls.ViewModel
{
    /// <summary>
    /// ViewModel du module de ClickMenu
    /// </summary>
    public class ClickMenuVM : BaseMVVM.ViewModel.ViewModel
    {
     
        private PolemicElement _selectedElement;
        /// <summary>
        /// PolémicElement sélectionné
        /// </summary>
        public PolemicElement SelectedElement
        {
            get
            {
                return _selectedElement;
            }
            set
            {
                _selectedElement = value;
                OnPropertyChanged("SelectedElement");
            }
        }
       
        public ClickMenuVM()
        {
            InitializeCommands();
        }
        private void InitializeCommands()
        {
            Commands.ClickMenu.AddToRefChutier.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(AddToRefChutier_Executed);
        }

        private void AddToRefChutier_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            Commands.ReferencesChutier.RefChutierAdd.Execute(SelectedElement);
        }
    }
}
