﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Controls.ViewModel;
namespace Iri.Modernisation.Controls.View
{
    public  class MenuableUserControl : UserControl
    {
        public MenuableUserControl()
        {
            MouseEnter += new MouseEventHandler(MenuableUserControl_MouseEnter);
            MouseLeave += new MouseEventHandler(MenuableUserControl_MouseLeave);
            MouseRightButtonDown += new MouseButtonEventHandler(MenuableUserControl_MouseRightButtonDown);

            MouseRightButtonUp += new MouseButtonEventHandler(MenuableUserControl_MouseRightButtonUp);
        }

        void MenuableUserControl_MouseLeave(object sender, MouseEventArgs e)
        {
            ((MenuableViewModel)base.DataContext).MenuableUserControl_MouseLeave(sender, e);
        }

        void MenuableUserControl_MouseEnter(object sender, MouseEventArgs e)
        {
            ((MenuableViewModel)base.DataContext).MenuableUserControl_MouseEnter(sender, e);
       
        }

        void MenuableUserControl_MouseRightButtonUp(object sender, MouseButtonEventArgs e)
        {
            ((MenuableViewModel)base.DataContext).DisactiveContextualMenu(sender, e);
        }

        void MenuableUserControl_MouseRightButtonDown(object sender, MouseButtonEventArgs e)
        {
            if (this.IsEnabled)
            {
                e.Handled = true;
                ((MenuableViewModel)base.DataContext).ActiveContextualMenu(sender, e);
            }
        }
      

        
    }
}
