﻿using System;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Controls.ViewModel;
namespace Iri.Modernisation.Controls.View
{
	public partial class AnnotationMaker : UserControl
	{
		public AnnotationMaker()
		{

			InitializeComponent();
            Commands.AnnotationMaker.FixAnnotationTime.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(FixAnnotationTime_Executed);
            Commands.HttpSenderResponse.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(HttpSenderResponse_Executed);
         }

        void FixAnnotationTime_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            EditableAnnotation.UpperRangeValue = EditableAnnotation.Maximum;
            EditableAnnotation.LowerRangeValue = EditableAnnotation.Minimum;
        }

      

     

        void HttpSenderResponse_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            this.Dispatcher.BeginInvoke(() => MessageBox.Show((String)e.Parameter));
        }
	}
}