﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM;
using Iri.Modernisation.BaseMVVM.ViewModel;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Data.Models;
using System.Collections.Generic;
namespace Iri.Modernisation.Controls.ViewModel
{
    /// <summary>
    /// ViewModel d'un PolemicElement
    /// </summary>
    public class PolemicElementVM : MenuableViewModel  
    {
     
        private MouseButtonEventArgs _selectedCoord;

        /// <summary>
        /// Temps d'entrée
        /// </summary>
        private TimeSpan _timerIn;
        public TimeSpan TimerIn 
        { 
            get
            {
                return _timerIn;
            }
            set
            {
                _timerIn = value;
                _element.TimerIn = value;
                OnPropertyChanged("TimerIn");
            }
        }

        /// <summary>
        /// Temps de sortie
        /// </summary>
        private TimeSpan _timerOut;
        public TimeSpan TimerOut
        {
            get
            {
                return _timerOut;
            }
            set
            {
                _timerOut = value;
                _element.TimerOut = value;
                OnPropertyChanged("TimerOut");
            }
        }

        /// <summary>
        /// Durée de l'élément
        /// </summary>
        public TimeSpan Duration
        {
            get 
            {
                return TimerOut - TimerIn; 
            }
            set 
            { 
                TimerOut = TimerIn + value; 
            }
        }

        /// <summary>
        /// Titre de l'élément
        /// </summary>
        private String _title;
        public String Title
        {
            get
            {
                return _title;
            }
            set
            {
                _title = value;
                _element.Title = value;
                OnPropertyChanged("Title");
            }
        }

        /// <summary>
        /// Description de l'élément
        /// </summary>
        private String _description;
        public String Description 
        {
            get
            {
                return _description;
            }
            set
            {
                _description = value;
                _element.Description = value;
                OnPropertyChanged("Description");
            }
        }

        /// <summary>
        /// Tags de l'élément
        /// </summary>
        private List<String> _tags;
        public List<String> Tags
        {
            get
            {
                return _tags;
            }
            set
            {
                _tags = value;
                _element.Tags = value;
                OnPropertyChanged("Tags");
            }
        }

        /// <summary>
        /// Chapitre référent de l'élément
        /// </summary>
        private VideoChapter _chapter;
        public VideoChapter Chapter
        {
            get
            {
                return _chapter;
            }
            set
            {
                _chapter = value;
                _element.Chapter = value;
                OnPropertyChanged("Chapter");
            }
        }

       /// <summary>
       /// Auteur de l'élément
       /// </summary>
        public User Contributer
        {
            get
            {
                try
                {
                   return ((Annotation)_element).Contributer;
                }
                catch
                {
                    return null;
                }
            }
           
        }

		public double Heigh
		{
			get
			{
				if(_element is SegmentIndex)
				{
					return 20;
				}
				else
				{
					return 10;
				}
				
			}
			
		}

        /// <summary>
        /// PolemicType de l'élément
        /// </summary>
        private Color _type;
        public SolidColorBrush Type
        {
            get
            {
                if (_element is SegmentIndex)
                {
                    return new SolidColorBrush(Chapter.Color);
                }
                else
                {
                    return new SolidColorBrush(_type);
                }
             
            }
            
            
        }
        private PolemicElement _element { get; set; }

        /// <summary>
        /// Constructeur
        /// </summary>
        /// <param name="element">PolémicElement</param>
        public PolemicElementVM(PolemicElement element)
            :base()
        {
            _element = element;
            TimerIn = _element.TimerIn;
            TimerOut = _element.TimerOut;
            Title = _element.Title;
            Description = _element.Description;
            Tags = _element.Tags;
            Chapter = _element.Chapter;
           
            if (_element is Annotation)
            {
                _type = ((Annotation)_element).Type.Color;
            }
        }



        public override void ActiveContextualMenu(object sender, MouseButtonEventArgs e)
        {

            _selectedCoord = e;
            Commands.PolemicElement.SelectPolemicElement.Execute(_element);
            Commands.PolemicElement.ElementSelected.Execute(_selectedCoord, _element);
            

        }
        public override void DisactiveContextualMenu(object sender, MouseButtonEventArgs e)
        {
          
            Commands.ContextualBinderLayer.EndBind.Execute(Type, _element);

        }
        public override void MenuableUserControl_MouseLeave(object sender, MouseEventArgs e)
        {
            Commands.ContextualBinderLayer.UnSelectBind.Execute();
        }
        public override void MenuableUserControl_MouseEnter(object sender, MouseEventArgs e)
        {
            Commands.ContextualBinderLayer.SelectBind.Execute(Type, _element);
        }
     
    }

}
