﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Controls.Primitives;
namespace Iri.Modernisation.Controls.View
{
    public class ExtendedSlider : Slider
    {

        public ExtendedSlider()
            : base()
        {
            DefaultStyleKey = typeof(Slider); 
        }

          /// <summary> 
        /// Fired when the thumb has been clicked, and dragging is initiated 
        /// </summary> 
        public event EventHandler<EventArgs> ThumbDragStarted; 
 
        /// <summary> 
        /// Fired when the thumb has been released 
        /// </summary> 
        public event EventHandler<EventArgs> ThumbDragCompleted; 
      
 
        public override void OnApplyTemplate() 
        { 
            base.OnApplyTemplate(); 
 
            //Set up drag event handlers 
            Thumb thumb = this.GetTemplateChild("HorizontalThumb") as Thumb; 
            if (thumb != null) 
            { 
                thumb.DragStarted += new DragStartedEventHandler(thumb_DragStarted); 
                thumb.DragCompleted += new DragCompletedEventHandler(thumb_DragCompleted); 
            } 
        } 
 
        void thumb_DragCompleted(object sender, DragCompletedEventArgs e) 
        { 
            OnThumbDragCompleted(this, new EventArgs()); 
        } 
 
        void thumb_DragStarted(object sender, DragStartedEventArgs e) 
        { 
            OnThumbDragStarted(this, new EventArgs()); 
        } 
 
        protected virtual void OnThumbDragStarted(object sender, EventArgs e) 
        { 
            if (ThumbDragStarted != null) 
                ThumbDragStarted(sender, e); 
        } 
 
        protected virtual void OnThumbDragCompleted(object sender, EventArgs e) 
        { 
            if (ThumbDragCompleted != null) 
                ThumbDragCompleted(sender, e); 
        } 
    }
}
