﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;

namespace Iri.Modernisation.Data.Models
{
    

    /// <summary>
    /// Classe PolemicElement
    /// </summary>
    public abstract class PolemicElement : SegmentElement
    {
        #region Attributes
        /// <summary>
        /// Id de l'élément
        /// </summary>
        public String Id { get; set; }

        /// <summary>
        /// Titre de l'élément
        /// </summary>
            public String Title {get;set;}
        /// <summary>
        /// Description de l'élément
        /// </summary>
            public String Description { get; set; }
        /// <summary>
        /// Tags de l'élément
        /// </summary>
            public List<String> Tags { get; set; }
        /// <summary>
            /// VideoChapter auquel l'annotation est ratachée
        /// </summary>
            public VideoChapter Chapter { get; set; }
       
        #endregion

          

        /// <summary>
        /// Constructeur par défaut
        /// </summary>
        protected PolemicElement()
        {
            Id = System.Guid.NewGuid().ToString();
            Tags = new List<String>();
        }

        /// <summary>
        /// Constructeur
        /// </summary>
        /// <param name="Vc">VideoChapter auquel l'annotation est ratachée</param>
        public PolemicElement(VideoChapter Vc):base()
        {
            Id = System.Guid.NewGuid().ToString();
            Chapter = Vc;
            Tags = new List<string>();
        }

        /// <summary>
        /// Constructeur par copie
        /// </summary>
        /// <param name="copy">Element à copier</param>
        public PolemicElement(PolemicElement copy): base(copy)
        {
            this.Id = copy.Id;
            this.Title = copy.Title;
            this.Description = copy.Description;
            this.Tags = new List<String>(copy.Tags);
        }

    }
}
