﻿using System;
using System.Net;
using System.Windows.Data;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
namespace Iri.Modernisation.Controls.Converter
{
    public class PolemicTypeColorConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            return Convert(value);

        }
        public static Brush Convert(object value)
        {
            SolidColorBrush returnBrush = new SolidColorBrush(new Color() { A = 255, R = 255, G = 255, B = 255 });
            if (value is PolemicElementType)
            {
                PolemicElementType dt = (PolemicElementType)value;
                
                switch (dt)
                {
                    case PolemicElementType.Basic:
                        returnBrush = new SolidColorBrush(new Color() { A = 255, R = 255, G = 255, B = 255 });
                        break;
                    case PolemicElementType.Polemic:
                        returnBrush = new SolidColorBrush(new Color() { A = 255, R = 255, G = 0, B = 0 });
                        break;
                    case PolemicElementType.Adhesion:
                        returnBrush = new  SolidColorBrush(new Color() { A = 255, R = 0, G = 255, B = 0 });
                        break;
                    case PolemicElementType.Reference:
                        returnBrush = new  SolidColorBrush(new Color() { A = 255, R = 0, G = 0, B = 255 });
                        break;
                    case PolemicElementType.Question:
                        returnBrush = new  SolidColorBrush(new Color() { A = 255, R = 255, G = 255, B = 0 });
                        break;
                    default:
                        returnBrush = new  SolidColorBrush(new Color() { A = 255, R = 255, G = 255, B = 255 });
                        break;
                }
               
            }
            else if(value is VideoChapterType)
            {
                VideoChapterType dt = (VideoChapterType)value;
                switch (dt)
                {
                    case VideoChapterType.Modernite: 
                        returnBrush = new SolidColorBrush(new Color() { A = 255, R = 0xBF, G = 0xA8, B = 0x4E });
                        break;
                    case VideoChapterType.Modernisation: 
                        returnBrush = new SolidColorBrush(new Color() { A = 255, R = 0xD6, G = 0xA3, B = 0x82 });
                        break;
                    case VideoChapterType.Postmodernite:
                        returnBrush = new SolidColorBrush(new Color() { A = 255, R = 0xB5, G = 0xCB, B = 0x29 });
                        break;
                    case VideoChapterType.Ouverture:
                        returnBrush = new SolidColorBrush(new Color() { A = 255, R = 0x5B, G = 0xCC, B = 0x5B });
                        break;
                    default:
                        break;
                }

            }
           
             return returnBrush;
        }
        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {

            throw new NotImplementedException();

        }
        /*
          case VideoChapterType.Modernite:
                    returnBrush = new SolidColorBrush(new Color() { A = 255, R = 0xD6, G = 0xA3, B = 0x82 });
                    break;
                case VideoChapterType.Modernisation:
                    returnBrush = new SolidColorBrush(new Color() { A = 255, R = 0xBF, G = 0xA8, B = 0x4E});
                    break;
                case VideoChapterType.Postmodernite:
                    returnBrush = new SolidColorBrush(new Color() { A = 255, R = 0xB5, G = 0xCB, B = 0x29 });
                    break;
                case VideoChapterType.Ouverture:
                    returnBrush = new SolidColorBrush(new Color() { A = 255, R = 0x5B, G = 0xCC, B = 0x5B });
                    break;
         */
    }
}
