﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Globalization;

namespace Iri.Modernisation.Data.Models
{
    public class VideoChapterDescription
    {
        public String Title { get; set; }
        public Color Color {get;set;}
        public int Id { get; set; }
        public VideoChapterDescription(int id,String title,String color)
        {
            Id = id;
            Title = title;
            Color = Color.FromArgb(
                byte.Parse(color.Substring(1,2),NumberStyles.AllowHexSpecifier),
                byte.Parse(color.Substring(3, 2), NumberStyles.AllowHexSpecifier),
                byte.Parse(color.Substring(5, 2), NumberStyles.AllowHexSpecifier),
                byte.Parse(color.Substring(7, 2), NumberStyles.AllowHexSpecifier));
           
        }
    }
}
