﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Xml.Linq;
using System.Collections.Generic;
namespace Iri.Modernisation.Data.Models
{
    public static class FactoryVideoLivre
    {
         public static WebClient xmlClient = new WebClient();
        private static XDocument _configDoc; 
         public static VideoChapterDescription[] VideoChapterDescriptions {get;private set;}
         public static int NumberOfChapters
         {
             get
             {
                 return VideoChapterDescriptions.Length;
             }
         }
         static FactoryVideoLivre()
	    {
 

	    }
        static public void Initialize()
        {
            LoadXMLFile();
        }
        static private void LoadXMLFile()
        {

            
            
            xmlClient.DownloadStringCompleted += new DownloadStringCompletedEventHandler(XMLFileLoaded);
            xmlClient.DownloadStringAsync(new Uri("ProjectConfig.xml",UriKind.Relative));
          
            
        }

        static void XMLFileLoaded(object sender, DownloadStringCompletedEventArgs e)
        {

            if (e.Error == null)
            {
            
                _configDoc = XDocument.Parse(e.Result);
                List<VideoChapterDescription> temp = new List<VideoChapterDescription>();
                int nb = 0;
                foreach (XElement XChapter in _configDoc.Root.Element("VideoBook").Elements())
                {
                    temp.Add(new VideoChapterDescription(nb, XChapter.Attribute("name").Value, XChapter.Attribute("color").Value));
                    nb++;
                }
                MessageBox.Show(nb.ToString());
                VideoChapterDescriptions = temp.ToArray();
            }
            else
            {
                //MessageBox.Show(e.Error.Message);
            }

        }
       static public void Load(string path)
       {
           _configDoc = XDocument.Load(path);
           List<VideoChapterDescription> temp = new List<VideoChapterDescription>();
           int nb = 0;
           foreach (XElement XChapter in _configDoc.Root.Element("VideoBook").Elements())
           {
               temp.Add(new VideoChapterDescription(nb,XChapter.Attribute("name").Value, XChapter.Attribute("color").Value));
               nb++;
           }
           VideoChapterDescriptions = temp.ToArray();
       }

     


       
    }
}
