﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Data.Models;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class HeaderProductionChapterVM : BaseMVVM.ViewModel.ViewModel
    {
        private VideoChapterDescription _chapterDescription;
        public VideoChapterDescription ChapterDescription
        {
            get
            {
                return _chapterDescription;
            }
            private set
            {
                _chapterDescription = value;
                OnPropertyChanged("ChapterDescription");
            }
        }


        private bool _isActive;
        public bool IsActive
        {
            get
            {
                return _isActive;
            }
            set
            {
                _isActive = value;
                OnPropertyChanged("IsActive");
            }
        }

        private bool _editing=false;
        public bool Editing
        {
            get
            {
                return _editing;
            }
            set
            {
                _editing = value;

                if(EditEnded!=null)
                EditEnded();

                OnPropertyChanged("Editing");
            }
        }

        private bool _indexing=false;
        public bool Indexing
        {
            get
            {
                return _indexing;
            }
            set
            {
                _indexing = value;
                OnPropertyChanged("Indexing");
                if (Ended!=null)
                {
                    Ended();
                }
            }
        }

        private bool _highLight;
        public bool HighLight
        {
            get
            {
                return _highLight;
            }
            set
            {
                _highLight = value;
                OnPropertyChanged(String.Empty);
            }
        }

        private HeaderProductionChapterVM _next=null;
        public HeaderProductionChapterVM Next
        {
            get
            {
                return _next;
            }
            set
            {
                _next = value;
                OnPropertyChanged("Next");
            }
        }

        private String _title;
        public String Title
        {
            get
            {
                return _title;
            }
            set
            {
                _title = value;
                OnPropertyChanged("Title");
            }
        }

        public void Enable()
        {
            IsActive = true;
           // Commands.ActivePart.Execute(null,this);
        }

       

        public HeaderProductionChapterVM(VideoChapterDescription Vcd)
        {
            _chapterDescription = Vcd;
            _title = Vcd.Title;
            HighLight = false;
           
        }
       
        public delegate void EditEndedDelegate();
        public event EditEndedDelegate EditEnded;

        public delegate void EndedDelegate();
        public event EndedDelegate Ended;


    }
}
