﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Threading;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.Controls.Converter;
using Iri.Modernisation.Data.Models;
namespace Iri.Modernisation.Controls.View
{
    public partial class ContextualBinderLayer : UserControl
    {
        private ContextualLinkBinder _movingBinder;
        private Line _linkLine;
        private bool _active = false;
        private System.Windows.Threading.DispatcherTimer myDispatcherTimer;
        public ContextualBinderLayer()
        {
            InitializeComponent();
            Commands.ContextualBinderLayer.EndBind.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(EndBind_Executed);
            MouseLeftButtonUp += new MouseButtonEventHandler(ContextualBinderLayer_MouseLeftButtonUp);
            MouseMove += new MouseEventHandler(ContextualBinderLayer_MouseMove);
            Commands.ContextualBinderLayer.BeginBind.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(BeginBind_Executed);  
            myDispatcherTimer = new System.Windows.Threading.DispatcherTimer();
            myDispatcherTimer.Interval = new TimeSpan(0, 0, 0, 0, 0);
            myDispatcherTimer.Tick +=new EventHandler(myDispatcherTimer_Tick);
        }

        void  myDispatcherTimer_Tick(object sender, EventArgs e)
        {
 	          LayoutRoot.Background = PolemicTypeColorConverter.Convert(_movingBinder.PolemicType);
                    LayoutRoot.Background.Opacity = 0.0;
                    _movingBinder.Visibility = Visibility.Visible;
                    _linkLine.Visibility = Visibility.Visible;
        }
        void EndBind_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            if (_active)
            {
                FlushDisplay();
            }
        }
        
        void ContextualBinderLayer_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            FlushDisplay();
        }
        private void FlushDisplay()
        {
            LayoutRoot.Children.Clear();
            _movingBinder.ReleaseMouseCapture();
            LayoutRoot.Background = null;
            _active = false;
            myDispatcherTimer.Stop();
            Commands.ContextualBinderLayer.DesactiveBind.Execute();
        }
       
        void ContextualBinderLayer_MouseMove(object sender, MouseEventArgs e)
        { 
            LayoutRoot.Background = null;
            _movingBinder.Visibility = Visibility.Collapsed;
            _linkLine.Visibility = Visibility.Collapsed;
            LayoutRoot.UpdateLayout();
            _movingBinder.Margin = new Thickness(
                                       e.GetPosition(this).X - _movingBinder.Width/2,
                                       e.GetPosition(this).Y - _movingBinder.Height / 2,
                                        0,
                                        0);
            _linkLine.X2 = e.GetPosition(this).X ;
            _linkLine.Y2 = e.GetPosition(this).Y;
        }

        void BeginBind_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            LayoutRoot.Children.Clear();
            _movingBinder =new ContextualLinkBinder( ((ContextualLinkBinder)e.Parameter));  
            _movingBinder.Margin = new Thickness(
             ((MouseButtonEventArgs)e.Source).GetPosition(this).X - _movingBinder.Width/ 2,
             ((MouseButtonEventArgs)e.Source).GetPosition(this).Y - _movingBinder.Height/2 ,
              _movingBinder.Margin.Right,
               _movingBinder.Margin.Bottom);
            _linkLine = new Line()
            {
                X1 = ((MouseButtonEventArgs)e.Source).GetPosition(this).X,
                Y1 = ((MouseButtonEventArgs)e.Source).GetPosition(this).Y,
                X2 = ((MouseButtonEventArgs)e.Source).GetPosition(this).X,
                Y2 = ((MouseButtonEventArgs)e.Source).GetPosition(this).Y,
                Stroke = PolemicTypeColorConverter.Convert(_movingBinder.PolemicType),
                StrokeThickness = 2
            };
            LayoutRoot.Background = PolemicTypeColorConverter.Convert(_movingBinder.PolemicType);
            LayoutRoot.Background.Opacity = 0.0;
            LayoutRoot.Children.Add(_movingBinder);
            LayoutRoot.Children.Add(_linkLine);
            _active = true;
            Commands.ContextualBinderLayer.ActiveBind.Execute();
            myDispatcherTimer.Start();  
        }
    }
}
