﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    public class IRIMedia
    {
        public String Id { get; set; }
        public List<IRIVideo> Videos { get; set; }
        public IRIMedia()
        {
            Id = String.Empty;
            Videos = new List<IRIVideo>();
        }
        public IRIMedia(XElement elem)
        {
            Id = elem.Attribute("id").Value;
            Videos = new List<IRIVideo>();
            foreach (XElement XVideos in elem.Elements())
            {
                Videos.Add(new IRIVideo(XVideos));
            }
        }
        public XElement XML
        {
            get
            { 
                XElement temp = new XElement("media",new XAttribute("id",Id));
                foreach (IRIVideo video in Videos)
                {
                    temp.Add(video.XML);
                }

                return temp;
            }
        }
    }
}
