﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
using Iri.Modernisation.Data.Models;
namespace Iri.Modernisation.Data.LDTClass
{
    /// <summary>
    /// Balise Element
    /// </summary>
    public class LDTElement
    {
        /// <summary>
        /// Attribut
        /// </summary>
        public String Id { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public Double Begin { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public Double Dur { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public String Author { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public DateTime Date { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public double Color { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public String Src { get; set; }
        /// <summary>
        /// Element
        /// </summary>
        public String Title { get; set; }
        /// <summary>
        /// Element
        /// </summary>
        public String Abstract { get; set; }
        /// <summary>
        /// Element
        /// </summary>
        public String Audio { get; set; }
        /// <summary>
        /// Elements
        /// </summary>
        public List<String> Tags { get; set; }
   

        /// <summary>
        /// Elements
        /// </summary>
        public String Video { get; set; }

        public LDTElement(Annotation annotation)
        {
            Id = annotation.Id;
            Title = annotation.Title;
            Abstract = annotation.Description;
            Begin = annotation.TimerIn.TotalMilliseconds;
            Dur = annotation.TimerOut.TotalMilliseconds - annotation.TimerIn.TotalMilliseconds;
            Tags = annotation.Tags;
            Date = DateTime.Now;
            Src = String.Empty;
            Author = String.Empty;
            Audio = String.Empty;
            Video = String.Empty;
        
            Color = double.Parse(annotation.Type.Color.A.ToString() + annotation.Type.Color.R.ToString() + annotation.Type.Color.G.ToString() + annotation.Type.Color.B.ToString());

            
        }

        public LDTElement(XElement e)
        {
            Tags = new List<String>();

            Id = e.Attribute("id").Value;
            Begin = Double.Parse(e.Attribute("begin").Value);
            Dur = Double.Parse(e.Attribute("dur").Value);
            Author = e.Attribute("author").Value;
            Date = DateTime.Parse(e.Attribute("date").Value);
            Color = double.Parse(e.Attribute("color").Value);
            Src = e.Attribute("src").Value;
            Title = e.Element("title").Value;
            Abstract = e.Element("abstract").Value;
            Audio = e.Element("audio").Value;
            if (e.Element("video")==null)
            {
                 Video = String.Empty;
            }
            else
            {
                Video = e.Element("video").Value;
            }
           
            foreach (XElement Str in e.Element("tags").Elements())
            {
                Tags.Add(Str.Value);
            }
        }
        public LDTElement()
        {
            Id = System.Guid.NewGuid().ToString();
      
            Begin = 0;
            Dur = 0;
            Author = String.Empty;
            Date = DateTime.Now;
            Color = 0;
            Src = String.Empty;
            Title = String.Empty;
            Abstract = String.Empty;
            Audio = String.Empty;
            Video = String.Empty;
            Tags = new List<string>();
        }

        public XElement XML
        {
            get
            {
                XElement temp = new XElement("element",
                    new XAttribute("id",Id),
                    new XAttribute("begin",Begin),
                    new XAttribute("dur",Dur),
                    new XAttribute("author",Author),
                    new XAttribute("date",Date.ToString("")),
                    new XAttribute("color",Color),
                    new XAttribute("src",Src),
                    new XElement("title",Title),
                    new XElement("abstract",Abstract),
                    new XElement("audio",Audio),
                    new XElement("video",Video)
                    );
                XElement XTags = new XElement("tags");
                foreach (String Tag in Tags)
                {
                    XTags.Add(new XElement("tag", Tag));
                }
                temp.Add(XTags);
                return temp;
            }
        }
    }
}
