﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    public class IRIEnsemble
    {
        //ensemble id="en_2" author="DDC - IRI" date="06/2006" display="2" title="Image" abstract="Découpage visuel"

        public String Id { get; set; }
        public String Author { get; set; }
        public DateTime Date { get; set; }
        public int Display { get; set; }
        public String Title { get; set; }
        public String Abstract { get; set; }
        public List<IRIDecoupage> Decoupages { get; set; }

        public IRIEnsemble()
        {
            Id = System.Guid.NewGuid().ToString();
            Author = String.Empty;
            Date = DateTime.Now;
            Display = 0;
            Title = String.Empty;
            Abstract = String.Empty;
            Decoupages = new List<IRIDecoupage>();
        }

        public IRIEnsemble(XElement elem)
        {
            Id = elem.Attribute("id").Value;
            Author = elem.Attribute("author").Value;
            Date = DateTime.Parse(elem.Attribute("date").Value);
            Display = int.Parse(elem.Attribute("display").Value);
            Title = elem.Attribute("title").Value;
            Abstract = elem.Attribute("abstract").Value;
            Decoupages = new List<IRIDecoupage>();
            foreach (XElement XDecoupage in elem.Elements("decoupage"))
            {
                Decoupages.Add(new IRIDecoupage(XDecoupage));
            }
        }
        public XElement XML
        {
            get
            {
                XElement temp = new XElement("ensemble",
                    new XAttribute("id",Id),
                    new XAttribute("author",Author),
                    new XAttribute("date", Date.ToString("dd/MM/yyyy")),
                    new XAttribute("display",Display),
                    new XAttribute("title",Title),
                    new XAttribute("abstract",Abstract));
                foreach (IRIDecoupage decoupage in Decoupages)
                {
                    temp.Add(decoupage.XML);
                }
                return temp;

            }
        }
    }
}
