﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Collections;
using Iri.Modernisation.Data.Models;
using System.Linq;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
namespace Iri.Modernisation.Controls.ViewModel
{
    /// <summary>
    /// ViewModel de ConsultationBook
    /// </summary>
    public class ConsultationBookViewVM : BaseMVVM.ViewModel.ViewModel
    {

        private VideoBook _selectedBook;
        /// <summary>
        /// Livre Sélectionné
        /// </summary>
        public VideoBook SelectedBook
        {
            get
            {
                return _selectedBook;
            }
            set
            {
                _selectedBook = value;
                OnPropertyChanged(null);
            }
        }

  

        private SegmentIndex _selectedIndex;
        /// <summary>
        /// Index Sélectionné
        /// </summary>
        public SegmentIndex SelectedIndex
        {
            get
            {
                
                return _selectedIndex;
            }
            set
            {
                if (value != null)
                {
                    _selectedIndex = value;
                    _selectedIndexTitle = ((SegmentIndex)value).Title;
                    _selectedIndexDescription = ((SegmentIndex)value).Description;
                    _selectedIndexTags = ((SegmentIndex)value).Tags;
                    _selectedBook = _selectedIndex.Chapter.Book;
                    _title = _selectedIndex.Chapter.Book.Title;
                    _author = _selectedIndex.Chapter.Book.Author;
                    _chapters = _selectedIndex.Chapter.Book.Chapters;
                    _selectedIndexAnnotation.Clear();
                    List<AnnotationViewerVM> _temp = new List<AnnotationViewerVM>();
                    foreach (Annotation An in ((SegmentIndex)value).Chapter.Annotations)
                    {
                        if (An.TimerIn <= ((SegmentIndex)value).TimerOut && An.TimerOut >= ((SegmentIndex)value).TimerIn)
                        {
                            _temp.Add(new AnnotationViewerVM(An));
                        }
                    }
                    SelectedIndexAnnotation = _temp;
                }
                else
                {
                    _selectedIndex = null;
                    _selectedIndexTitle = String.Empty;
                    _selectedIndexDescription = String.Empty;
                    _selectedIndexTags = new List<string>();
                    _selectedBook = null;
                    _title = null;
                    _author = null;
                    _chapters = null;
                    _selectedIndexAnnotation.Clear();
                  
                    SelectedIndexAnnotation = new List<AnnotationViewerVM>();
                }
                OnPropertyChanged(null);
            
         
            }
        }

        private String _selectedIndexTitle;
        /// <summary>
        /// Titre de l'Index
        /// </summary>
        public String SelectedIndexTitle
        {
            get
            {
                return _selectedIndexTitle;
            }
            set
            {
                _selectedIndexTitle = value;
                OnPropertyChanged("SelectedIndexTitle");
            }
        }

        private String _selectedIndexDescription;
        /// <summary>
        /// Description de L'index
        /// </summary>
        public String SelectedIndexDescription
        {
            get
            {
                return _selectedIndexDescription;
            }
            set
            {
                _selectedIndexDescription = value;
                OnPropertyChanged("SelectedIndexDescription");
            }
        }

        private List<String> _selectedIndexTags = new List<string>();
        /// <summary>
        /// Tags de l'Index
        /// </summary>
        public String SelectedIndexTags
        {
            get
            {
                try
                {
                    return String.Join(",", _selectedIndexTags.ToArray());
                }
                catch
                {
                    return String.Empty;
                }
            }
            set
            {
                String val = (String)value;
                _selectedIndexTags = val.Split(',').ToList();
                OnPropertyChanged("SelectedIndexTags");
            }
        }

        private List<AnnotationViewerVM> _selectedIndexAnnotation = new List<AnnotationViewerVM>();
       /// <summary>
       /// Liste des annotations de l'index
       /// </summary>
        public List<AnnotationViewerVM> SelectedIndexAnnotation
        {
            get
            {
               return _selectedIndexAnnotation;
            }
            set
            {
                _selectedIndexAnnotation = value;
                OnPropertyChanged("SelectedIndexAnnotation");
            }
        }
        

        private String _title;
        /// <summary>
        /// Titre du VideoLivre
        /// </summary>
        public String Title
        {
            get
            {
                return _title;
            }
            private set
            {
                _title = value;
           
                OnPropertyChanged("Title");
            }
        }

        private User _author;
        /// <summary>
        /// Auteur du Videolivre
        /// </summary>
        public User Author
        {
            get
            {
                return _author;
            }
            private set
            {
                _author = value;
            
                OnPropertyChanged("Author");
            }

        }

        private VideoChapter[] _chapters;
        /// <summary>
        /// Chapitres du VideoLivre
        /// </summary>
        public VideoChapter[] Chapters
        {
            get
            {
                return _chapters;
            }
            private set
            {
                _chapters = value;
        
                OnPropertyChanged("Chapters");
            }
        }

        private List<SegmentIndex>[] _segmentIndex = new List<SegmentIndex>[4];
        /// <summary>
        /// 
        /// </summary>
        public List<SegmentIndex>[] SegmentIndex
        {
            get
            {
                return _segmentIndex;
            }
            set
            {
                _segmentIndex = value;
                OnPropertyChanged("SegmentIndex");
            }
        }

        private List<Annotation>[] _annotations = new List<Annotation>[4];
        /// <summary>
        /// Annotations
        /// </summary>
        public List<Annotation>[] Annotations
        {
            get
            {
                return _annotations;
            }
            set
            {
                _annotations = value;
                OnPropertyChanged("Annotations");
            }
        }

        private BookTimeLineVM _selectedBookVM;
        /// <summary>
        /// ViewModel de BookTimeLine
        /// </summary>
        public BookTimeLineVM SelectedBookVM
        {
            get
            {
                return _selectedBookVM;
            }
            set
            {
                if (value != null)
                {
                    _selectedBookVM = value;

                    _selectedBook = value.SelectedBook;
                    _title = value.SelectedBook.Title;
                    _author = value.SelectedBook.Author;
                    _chapters = value.SelectedBook.Chapters;
                    ActualVideoSourceVM.Source = value.SelectedBook.MediaPath;
                    ActualVideoSourceVM.Position = TimeSpan.FromMilliseconds(value.Position);



                    SelectedIndex = value.SelectedBook.Chapters[0].Index[0];
                    Commands.GoToTime.Execute(value.Position);
                }
                else
                {
                    _selectedBookVM = null;
                    _selectedBook = null;
                    _title = null;
                    _author = null;
                    _chapters = null;
                    ActualVideoSourceVM.Source = null;
                    ActualVideoSourceVM.Position = TimeSpan.Zero;
                    SelectedIndex = null;
                }
                OnPropertyChanged(String.Empty);
              
            }
        }
        private VideoViewerVM _actualVideoSourceVM;
        /// <summary>
        /// Video Actuellement en visionnage
        /// </summary>
        public VideoViewerVM ActualVideoSourceVM
        {
            get
            {
                return _actualVideoSourceVM;
            }
            set
            {
                _actualVideoSourceVM = value;
                OnPropertyChanged("ActualVideoSourceVM");
            }
        }
        public ConsultationBookViewVM()
        {
          
            ActualVideoSourceVM = new VideoViewerVM(true,false);
            InitializeCommands();


        }
        public ConsultationBookViewVM(BookTimeLineVM param)
        {
            _selectedBookVM = param;
            _selectedBook = param.SelectedBook;
            _title = param.SelectedBook.Title;
            _author = param.SelectedBook.Author;
            _chapters = param.SelectedBook.Chapters;
           
            if (param.SelectedBook.Chapters[0].VideoSequences.Count != 0)
            {
                ActualVideoSourceVM = new VideoViewerVM(true,false) { Source = param.SelectedBook.MediaPath }; 
            }
            SelectedIndex = param.SelectedBook.Chapters[0].Index[0];
            
            InitializeCommands();
           
          

        }

        void ActualVideoSourceVM_PropertyChanged(object sender, System.ComponentModel.PropertyChangedEventArgs e)
        {
         
            if (e.PropertyName == "Position")
            {
                if (SelectedBook != null)
                {
                    TimeSpan Pos = TimeSpan.FromMilliseconds(SelectedBookVM.Position);
                    SelectedBookVM.Position = Pos.TotalMilliseconds;
                    if (SelectedIndex.TimerOut < Pos || SelectedIndex.TimerIn > Pos)
                    {
                        foreach (SegmentIndex Index in SelectedIndex.Chapter.Index)
                        {
                            if (Index.TimerIn <= Pos && Index.TimerOut >= Pos)
                            {
                                SelectedIndex = Index;
                            }

                        }
                    }
                }
            }
        }
        private void InitializeCommands()
        {
            ActualVideoSourceVM.Tick += new EventHandler<VideoViewerVMEventArgs>(ActualVideoSourceVM_Tick);
            Commands.TimeChange.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(TimeChange_Executed);
        }

        void TimeChange_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            BookTimeLineVM BookTimeLineVM = (BookTimeLineVM)e.Source;

            if (BookTimeLineVM == this.SelectedBookVM)
            {
                UpdateAnnotation();
            }
        }

        private void UpdateAnnotation()
        {
            if (SelectedBook != null)
            {
                TimeSpan Pos = TimeSpan.FromMilliseconds(SelectedBookVM.Position);
                SelectedBookVM.Position = Pos.TotalMilliseconds;
                if (SelectedIndex.TimerOut < Pos || SelectedIndex.TimerIn > Pos)
                {
                    foreach (SegmentIndex Index in SelectedIndex.Chapter.Index)
                    {
                        if (Index.TimerIn <= Pos && Index.TimerOut >= Pos)
                        {
                            SelectedIndex = Index;
                        }

                    }
                }
            }
        }

        private void ActualVideoSourceVM_Tick(object sender, VideoViewerVMEventArgs e)
        {
            SelectedBookVM.Position =  e.Position.TotalMilliseconds;
            UpdateAnnotation();
        }
       
    }
}
