﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace Iri.Modernisation.Controls.View
{
   
    public partial class ButtonHeaderControl : UserControl
    {
        public ButtonHeaderControl()
        {
           
            InitializeComponent();
        }

        Point tempPoint = new Point();

        private void LayoutRoot_MouseMove(object sender, MouseEventArgs e)
        {
          
            Point p = e.GetPosition(this);
            tempPoint.X = 1-  (p.X / ActualWidth);
            //tempPoint.Y = p.Y / ActualHeight;
            tempPoint.Y = 1 - (p.Y / ActualWidth); ;
            brushLight.Center = tempPoint;
            brushLight.GradientOrigin = tempPoint;

        }

        string _title = String.Empty;


        /// <summary>
        /// Title of the toolbar item
        /// </summary>
    
        public String Title
        {
            get { return (String)GetValue(TitleProperty);}
            set { SetValue(TitleProperty, value); _title = value; }
        }

        // Using a DependencyProperty as the backing store for Title.  This enables animation, styling, binding, etc...
        public static readonly DependencyProperty TitleProperty =
            DependencyProperty.Register("Title", typeof(String), typeof(ButtonHeaderControl),    null);



     

        /// <summary>
        /// The transition color when we hover over the button
        /// </summary>
        public Color TransitionColor
        {
            get
            {
                return transitionColor.Color;
            }
            set
            {
                transitionColor.Color = value;
                transitionSubColor.Color = Color.FromArgb(64, value.R, value.G, value.B);
            }
        }

        /// <summary>
        /// The source of the image to display for the control
        /// </summary>
        public ImageSource ImageSource
        {
            get { return imgItem.Source; }
            set { imgItem.Source = value; }
        }

        private void LayoutRoot_MouseEnter(object sender, MouseEventArgs e)
        {
           
            animEnter.Begin();
        }

        private void LayoutRoot_MouseLeave(object sender, MouseEventArgs e)
        {
        
            animLeave.Begin();

        }

        /// <summary>
        /// Uri to navigate to when clicked
        /// </summary>
        public string NavigateUri { get; set; }

        /// <summary>
        /// true to open link in new window, false to open link in current window
        /// default is false
        /// </summary>
        public bool OpenInNewWindow { get; set; }

        private void UserControl_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            if (NavigateUri != null)
            {
                if (OpenInNewWindow)
                {
                    System.Windows.Browser.HtmlPage.Window.Navigate(new Uri(NavigateUri, UriKind.Absolute), "_new");
                }
                else
                {
                    System.Windows.Browser.HtmlPage.Window.Navigate(new Uri(NavigateUri, UriKind.Absolute));
                }
            }

        }
    }
}
