﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.ViewModel;
using Iri.Modernisation.BaseMVVM.Commands;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class HeaderControlVM : BaseMVVM.ViewModel.ViewModel
    {
        private String _connectedName = String.Empty;
        /// <summary>
        /// Nom de la personne connecté
        /// </summary>
        public String ConnectedName
        {
            get
            {
                if (_connectedName != String.Empty)
                {
                    return _connectedName;
                }
                else
                {
                    return Iri.Modernisation.Lang.LangResource.MenuNotConnectedLabel;
                }
            }
            set
            {
                _connectedName = value;
                OnPropertyChanged("ConnectedName");
            }
        }
        public HeaderControlVM()
        {
            InitializeCommands();
        }
        public HeaderControlVM(String name)
        {
            _connectedName = name;
            InitializeCommands();
        }
        private void InitializeCommands() 
        {
            Commands.HeaderControl.ButtonClick.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(ButtonClick_Executed);
        }

        private void ButtonClick_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            MessageBox.Show(e.Parameter.ToString());
        }
    }
}
