﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace Iri.Modernisation.Data.Models
{
    /// <summary>
    /// Classe servant à synchroniser les Loaders
    /// On créé la classe, on enregistre les Loader a synchroniser.
    /// /* Utilisation */
    /// Attention /!\ Il faut enregistrer le loader APRES s'êtres abonnée à son event LoaderFinished.
    /// </summary>
    public class Sync
    {
        /// <summary>
        /// Constructeur par défaut
        /// </summary>
        public Sync()
        { _registeredLoader = 0; }
        private int _registeredLoader { get; set; }

        /// <summary>
        /// Méthode permettant d'enregistrer les Loader au sein d'un même Sync
        /// </summary>
        /// <param name="loader">Loader à enregistrer</param>
        public void RegisterLoader(ILoader loader)
        {
            _registeredLoader++;
            loader.LoaderFinished += new EventHandler<EventArgs>(loader_LoaderFinished);
        }

        private void loader_LoaderFinished(object sender, EventArgs e)
        {
            _registeredLoader--;
            if (_registeredLoader == 0)
            {
                Completed(this, new EventArgs());
            }
        }
      
        /// <summary>
        /// Evenement déclanché une fois tous les Loader fini
        /// </summary>
        public event EventHandler<EventArgs> Completed;

    }
}
