﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.IO;
using System.Threading;
namespace Iri.Modernisation.Data.Models
{
    public class HttpSender
    {
        private HttpWebRequest Request { get; set; }
        public Dictionary<string, string> PostValues { get; private set; }
        public String Response { get; private set; }
        
        public event HttpResponseCompleteEventHandler ResponseComplete;
        private void OnResponseComplete(HttpResponseCompleteEventArgs e)
        {
            if (this.ResponseComplete != null)
            {
                ThreadPool.QueueUserWorkItem(new WaitCallback((Object o)=>this.ResponseComplete(e)));
               // this.ResponseComplete(e);
            }
        }
        private void OnResponseComplete()
        {
            if (this.ResponseComplete != null)
            {
                ThreadPool.QueueUserWorkItem(new WaitCallback((Object o) => new HttpResponseCompleteEventArgs(Response)));
                this.ResponseComplete(new HttpResponseCompleteEventArgs(Response));
            }
        }
        public HttpSender(Uri requestUri, string method, params KeyValuePair<string, string>[] postValues)
        {
            this.Request = (HttpWebRequest)WebRequest.Create(requestUri);
            this.Request.ContentType = "application/x-www-form-urlencoded";
            this.Request.Method = method;
            this.PostValues = new Dictionary<string, string>();
            if (postValues != null && postValues.Length > 0)
            {
                foreach (var item in postValues)
                {
                    this.PostValues.Add(item.Key, item.Value);
                }
            }
        }

        public void Execute()
        {
            this.Request.BeginGetRequestStream(new AsyncCallback(BeginRequest), this);
            
        }

        private  void BeginRequest(IAsyncResult ar)
        {
            HttpSender helper = ar.AsyncState as HttpSender;
            if (helper != null)
            {
                if (helper.PostValues.Count > 0)
                {
                    using (StreamWriter writer = new StreamWriter(helper.Request.EndGetRequestStream(ar)))
                    {
                        foreach (var item in helper.PostValues)
                        {
                            writer.Write("{0}={1}&", item.Key,item.Value);
                        }
                       
                    }
                }
                helper.Request.BeginGetResponse(new AsyncCallback(BeginResponse), helper);
            }
        }

        private  void BeginResponse(IAsyncResult ar)
        {
            HttpSender helper = ar.AsyncState as HttpSender;
            if (helper != null)
            {
                HttpWebResponse response = (HttpWebResponse)helper.Request.EndGetResponse(ar);
                if (response != null)
                {
                    Stream stream = response.GetResponseStream();
                    if (stream != null)
                    {
                        using (StreamReader reader = new StreamReader(stream))
                        {
                            helper.Response = reader.ReadToEnd();
                        }
                    }
                }
            }
            this.OnResponseComplete();
        }
    }

    public delegate void HttpResponseCompleteEventHandler(HttpResponseCompleteEventArgs e);
    public class HttpResponseCompleteEventArgs : EventArgs
    {
        public string Response { get; set; }

        public HttpResponseCompleteEventArgs(string response)
        {
            this.Response = response;
        }
    }


    /*
      using Of the class
      private void ProcessCommand(short cmd, string msg)
        {
            App app = App.Current as App;
            HttpHelper helper = new HttpHelper(app.ServerUri, "POST", 
                new KeyValuePair<string, string>("authKey", app.AuthKey),
                new KeyValuePair<string, string>("cmd", cmd.ToString()),
                new KeyValuePair<string, string>("msg", msg));
            helper.ResponseComplete += new HttpResponseCompleteEventHandler(this.CommandComplete);
            helper.Execute();

        }

        private void CommandComplete(HttpResponseCompleteEventArgs e)
        {
            txtAlert.Text = e.Response;
        }
     */

}
