﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
   
    public class LDTRelation
    {
        public String IdElementFrom { get; set; }
        public String IdElementTo { get; set; }
        public String Title { get; set; }
        public String Type { get; set; }
        public LDTRelation()
        {
            IdElementFrom = String.Empty;
            IdElementTo = String.Empty;
            Title = String.Empty;
            Type = String.Empty;
        }
        public LDTRelation(XElement elem)
        {
            

            IdElementFrom = elem.Attribute("idElementFrom").Value;
            IdElementTo = elem.Attribute("idElementTo").Value;
            Title = elem.Attribute("title").Value;
            Type = elem.Attribute("type").Value;
        }

        public XElement XML
        {
            get
            {
                if(IdElementFrom==null)
                {
                    IdElementFrom = String.Empty;
                }
                if(IdElementTo == null)
                {
                    IdElementTo = String.Empty;
                }
                if(Title == null)
                {
                    Title = String.Empty;
                }
                if(Type == null)
                {
                    Type = String.Empty;
                }
                return new XElement("relation",
                    new XAttribute("idElementFrom", IdElementFrom),
                    new XAttribute("idElementTo", IdElementTo),
                    new XAttribute("title", Title),
                    new XAttribute("type",Type)
                    );
            }
        }


    }
}
