﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.Data.Models;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using System.Collections.Generic;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class HeaderProductionVM : BaseMVVM.ViewModel.ViewModel
    {

        private List<HeaderProductionChapterVM> _productionChapters;
        public List<HeaderProductionChapterVM> ProductionChapters
        {
            get
            {
                return _productionChapters;
            }
            set
            {
                _productionChapters = value;
                OnPropertyChanged("ProductionChapters");
            }
        }

        private HeaderProductionChapterVM _selectedChapter;
        public HeaderProductionChapterVM SelectedChapter
        {
            get
            {
                return _selectedChapter;
            }
            set
            {
                if (_selectedChapter != null)
                {
                    _selectedChapter.HighLight = false;
                    _selectedChapter.EditClicked -= new EventHandler(value_EditClicked);
                    _selectedChapter.IndexClicked -= new EventHandler(value_IndexClicked);
                }

                _selectedChapter = value;
               value.EditClicked+=new EventHandler(value_EditClicked);
               value.IndexClicked+=new EventHandler(value_IndexClicked);
                    value.HighLight = true;
                    if (Change != null)
                        Change(this, new HeaderProductionVMArgs(SelectedChapter));

                UpdateInstructionMessage();
                OnPropertyChanged("SelectedChapter");
            }

        }
        public event EventHandler IndexClicked;
        public event EventHandler EditClicked;
        void value_IndexClicked(object sender, EventArgs e)
        {
            IndexClicked(sender, e);
        }

        void value_EditClicked(object sender, EventArgs e)
        {
            EditClicked(sender, e);
        }
        public void EditOk()
        {
            SelectedChapter.Editing = true;
            Commands.HeaderProduction.EditFinishedOk.Execute(null, SelectedChapter);
        }
        public void IndexOk()
        {
             SelectedChapter.Indexing = true;
            Commands.HeaderProduction.IndexFinishedOk.Execute(null, SelectedChapter);
        }
       private void UpdateInstructionMessage()
       {
           if (!_selectedChapter.Editing)
                {
                    if (this.ProductionChapters.IndexOf(_selectedChapter) == 0)
                    {
                        Instruction = Lang.LangResource.EditionFirstMessage.Replace("{0}",SelectedChapter.Title);
                    }
                    else
                    {
                        if (!this.ProductionChapters[this.ProductionChapters.IndexOf(_selectedChapter) - 1].Editing)
                        {
                            Instruction = Lang.LangResource.NotActivedChapter.Replace("{0}", SelectedChapter.Title);
                        }
                        else
                        {
                            Instruction = Lang.LangResource.EditionSecondMessage.Replace("{0}", SelectedChapter.Title);
                        }
                    }
                }
           else if (!_selectedChapter.Indexing)
                {
                    Instruction = Lang.LangResource.IndexationMessage.Replace("{0}", SelectedChapter.Title);
                }
                else
                {
                    Instruction = Lang.LangResource.EnrichmentMessage.Replace("{0}", SelectedChapter.Title);
                }
       }
        public bool IsVideoBookComplete
        {
            get
            {
                bool test = true;
                foreach(HeaderProductionChapterVM Hpcvm in ProductionChapters )
                {
                    test = Hpcvm.Indexing && test; 
                }
                return test;
            }
        }
        private String _instruction;
        /// <summary>
        /// Instruction
        /// </summary>
        public String Instruction
        {
            get
            {
                return _instruction;
            }
            set
            {
                _instruction = value;
                OnPropertyChanged("Instruction");
            }
        }
        public HeaderProductionVM()
        {
            _productionChapters = new List<HeaderProductionChapterVM>();
            HeaderProductionChapterVM temp = null;
            foreach (VideoChapterDescription Vcd in FactoryVideoLivre.VideoChapterDescriptions)
            {
                temp = new HeaderProductionChapterVM(Vcd);
                temp.Ended +=new HeaderProductionChapterVM.EndedDelegate(Ended);
                temp.EditEnded += new HeaderProductionChapterVM.EditEndedDelegate(EditEnded);
                temp.HighLight = false;
               _productionChapters.Add(temp);
               if(_productionChapters.Count > 1)
               {
                   _productionChapters[_productionChapters.Count - 2].EditEnded+=new HeaderProductionChapterVM.EditEndedDelegate(temp.Enable);
                   
               }
           
              
                
            }
            Instruction = Lang.LangResource.OpenProductionMessage;
           
            InitializeCommands();
            ProductionChapters[0].Enable();
          
    
        }

        private void EditEnded()
        {
            if(Change!=null)
            Change(this,new HeaderProductionVMArgs(SelectedChapter));

            UpdateInstructionMessage();
        }
       
       

        private void Ended()
        {
            OnPropertyChanged("IsVideoBookComplete");
            if (Change != null)
                Change(this, new HeaderProductionVMArgs(SelectedChapter));

            UpdateInstructionMessage();
        }
        private void InitializeCommands()
        {
        }
        public event EventHandler<HeaderProductionVMArgs> Change;
     
       
    }
    public class HeaderProductionVMArgs : EventArgs
    {
  
        public HeaderProductionChapterVM ChapterHeader { get; private set; }

        public HeaderProductionVMArgs( HeaderProductionChapterVM chapterHeader)
        {
            ChapterHeader = chapterHeader;
          

           
        }
    }
}
