﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    /// <summary>
    /// Balise Edit
    /// </summary>
    public class LDTEdit
    {
        /// <summary>
        /// Attribut
        /// </summary>
        public String Id { get; set; }
        /// <summary>
        /// Attribut
        /// </summary>
        public String Tags { get; set; }
        /// <summary>
        /// Elements
        /// </summary>
        public List<LDTInst> eList { get; set; }
        /// <summary>
        /// Element
        /// </summary>
        public String Caption { get; set; }
        /// <summary>
        /// Element
        /// </summary>
        public String Audio { get; set; }
        /// <summary>
        /// Elements
        /// </summary>
        public List<LDTm> mList { get; set; }
        public LDTEdit(XElement e) 
        {
            eList = new List<LDTInst>();
            mList = new List<LDTm>();

            Id = e.Attribute("id").Value;
            Tags = e.Attribute("tags").Value;
            foreach (XElement Elem in e.Element("eList").Elements())
            {
                eList.Add(new LDTInst(Elem));
            }

            Caption = e.Element("caption").Value;
            Audio = e.Element("audio").Value;

            foreach (XElement Elem in e.Element("mList").Elements())
            {
                mList.Add(new LDTm(Elem));
            }
        }
        public XElement XML
        {
            get
            {
                XElement temp = new XElement("edit",
                    new XAttribute("id",Id),
                    new XAttribute("tags",Tags)
                    );
                /* Ajout de eList */
                XElement XeList = new XElement("eList");
                foreach (LDTInst inst in eList)
                {
                    XeList.Add(inst.XML);
                }
                temp.Add(XeList);

                temp.Add(new XElement("caption",Caption));
                temp.Add(new XElement("audio",Audio));

                /* Ajout de mList */
                XElement XmList = new XElement("mList");
                foreach(LDTm m in mList)
                {
                    XmList.Add(m.XML);
                }
                temp.Add(XmList);

                return temp;

            }
        }
    }
}
