﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    /// <summary>
    /// Balise Media
    /// </summary>
    public class LDTMedia
    {
        /// <summary>
        /// Attribut
        /// </summary>
        public String Id { get; set; }

        /// <summary>
        /// Attribut
        /// </summary>
        public String Src { get; set; }

        /// <summary>
        /// Attribut
        /// </summary>
        public String Video { get; set; }

        /// <summary>
        /// Attribut
        /// </summary>
        public String Pict { get; set; }

        /// <summary>
        /// Attribut
        /// </summary>
        public String Extra { get; set; }

        #region Constructors

        public LDTMedia()
        {

        }

        public LDTMedia(XElement e)
        {
            if(e.Name != "media")
            {
                throw new Exception("XML node name doesn't match (LDT Media)");
            }
            Id = e.Attribute("id").Value;
            Src = e.Attribute("src").Value;
            Video = e.Attribute("video").Value;
            Pict = e.Attribute("pict").Value;
            Extra = e.Attribute("extra").Value;
        }
        #endregion
        public XElement XML
        {
            get
            {
                return new XElement("media",
                    new XAttribute("id",Id),
                    new XAttribute("src",Src),
                    new XAttribute("video",Video),
                    new XAttribute("pict",Pict),
                    new XAttribute("extra",Extra)
                    );
            }
        }
        

    }
}
