﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Collections.Generic;
using System.Xml.Linq;
namespace Iri.Modernisation.Data.LDTClass
{
    /// <summary>
    /// Classe Abstraite de Base pour la balise Découpage
    /// </summary>
    public abstract class LDTDecoupage
    {
        /// <summary>
        /// Attribut
        /// </summary>
        public String Id { get; set; }
        public LDTDecoupage(){}


    }

    /// <summary>
    /// Classe Decoupage issue des Annotations
    /// </summary>
    public class LDTAnnotationsDecoupage : LDTDecoupage
    {
        /// <summary>
        /// Attribut
        /// </summary>
        public String Author { get; set; }

        /// <summary>
        /// Element
        /// </summary>
        public String Title { get; set; }

        /// <summary>
        /// Element
        /// </summary>
        public String Abstract { get; set; }

        /// <summary>
        /// Elements
        /// </summary>
        public List<LDTElement> Elements { get; set; }

        public LDTAnnotationsDecoupage(XElement e)
        {
            Elements = new List<LDTElement>();
            Id = e.Attribute("id").Value;
            Author = e.Attribute("author").Value;
            Title = e.Element("title").Value;
            Abstract = e.Element("abstract").Value;

            foreach (XElement Elem in e.Element("elements").Elements())
            {
                Elements.Add(new LDTElement(Elem));
            }
        }
        public XElement XML
        {
            get
            {
                XElement temp = new XElement("decoupage",
                    new XAttribute("id", Id),
                    new XAttribute("author", Author),
                    new XElement("title",Title),
                    new XElement("abstract",Abstract)
                    );
                XElement Xelements = new XElement("elements");
                foreach (LDTElement element in Elements)
                {
                    Xelements.Add(element.XML);
                }
                temp.Add(Xelements);
                return temp;
            }
        }
    }

    /// <summary>
    /// Classe Decoupage issue des Displays
    /// </summary>
    public class LDTDisplaysDecoupage : LDTDecoupage
    {
        /// <summary>
        /// Attribut
        /// </summary>
        public String IdEns { get; set; }

        /// <summary>
        /// Attribut
        /// </summary>
        public String TagsSelect { get; set; }

        public LDTDisplaysDecoupage(XElement e)
        {
            Id = e.Attribute("id").Value;
            IdEns = e.Attribute("idens").Value;
            TagsSelect = e.Attribute("tagsSelect").Value;
        }
        public XElement XML
        {
            get
            {
                return new XElement("decoupage",
                    new XAttribute("id",Id),
                    new XAttribute("idens",IdEns),
                    new XAttribute("tagsSelect",TagsSelect)
                    );
            }
        }
    }
}
