﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Iri.Modernisation.BaseMVVM.Commands;
using Iri.Modernisation.BaseMVVM.ViewModel;
using Iri.Modernisation.Controls.View;
using Iri.Modernisation.Data.Models;
using System.Collections.ObjectModel;
using System.Collections.Generic;
namespace Iri.Modernisation.Controls.ViewModel
{
    public class ProductionViewVM : BaseMVVM.ViewModel.ViewModel
    {

        private VideoSequence _selectedVideoSequence;
        public VideoSequence SelectedVideoSequence
        {
            get
            {
                return _selectedVideoSequence;
            }
            set
            {
                _selectedVideoSequence = value;
                OnPropertyChanged("SelectedVideoSequence");
               
            }
        }

        private ObservableCollection<VideoSequence> _recordedVideoSequences;
        public ObservableCollection<VideoSequence> RecordedVideoSequences
        {
            get
            {
                return _recordedVideoSequences;
            }
            set
            {
                _recordedVideoSequences = value;
                OnPropertyChanged("RecordedVideoSequences");
            }
        }


        private HeaderProductionVM _headerProductionVM;
        public HeaderProductionVM ViewModelHeaderProduction
        {
            get
            {
                return _headerProductionVM;
            }
            set
            {
                _headerProductionVM = value;
                OnPropertyChanged("ViewModelHeaderProduction");
            }
        }
        private ProductionTimeLineVM _productionTimeLineVM;
        public ProductionTimeLineVM ViewModelProductionTimeLine
        {
            get
            {
                return _productionTimeLineVM;
            }
            set
            {
                _productionTimeLineVM = value;
                OnPropertyChanged("ViewModelProductionTimeLine");
            }
        }
        //SelectedChapter
        public ProductionViewVM()
        {
            RecordedVideoSequences = new ObservableCollection<VideoSequence>();
            ViewModelHeaderProduction = new HeaderProductionVM();
            ViewModelProductionTimeLine = new ProductionTimeLineVM();
            Commands.ProductionView.ClickAddSelectedRecord.Executed += new EventHandler<SLExtensions.Input.ExecutedEventArgs>(ClickAddSelectedRecord_Executed);
            Random rndNumbers = new Random();
            for (int i = 0; i < 10; i++)
            {
         
                _recordedVideoSequences.Add(new VideoSequence()
                {
                    Path="/Pouet/Record_"+rndNumbers.Next(10, 60),
                    RunTime = new TimeSpan(0, rndNumbers.Next(10, 60), 0),
                    BeginTrim = new TimeSpan(0, 0, 0),
                    EndTrim = new TimeSpan(0, 0, 0),
                });
            }
           
        }

        void ClickAddSelectedRecord_Executed(object sender, SLExtensions.Input.ExecutedEventArgs e)
        {
            if (ViewModelProductionTimeLine.SelectedChapter != -1)
            {
                if (!ViewModelProductionTimeLine.IsIndexing)
                {
                    if(SelectedVideoSequence!=null)
                    ViewModelProductionTimeLine.SelectedVideoSequences.Add(new VideoSequence(SelectedVideoSequence));
                }
               
            }
           
        }
       
       
    }
}
